import db from "../db-config.js";
import { countQueryCondition, whereCondition } from "../helper/general.js";
import { sendResponse } from "../helper/wrapper.js";
import BodyPart from "../sequelize/BodyPartSchema.js";

  /** Function to view all or single BodyPart */
  export const viewBodyPart = async (req, res) => {
    const { id } = req.params;
    const condition = await whereCondition({
      table: "body_part",
      page: req.query.page,
      all: req.query.all,
      pageSize: req.query.pageSize,
      filter: req.query.filter,
      id,
      grouped: req.query.grouped,
    });
    let fetchQuery = `SELECT body_part.id , body_part.label, body_part.parent_id as parentId FROM body_part WHERE body_part.deleted = 0 ${condition}`;
       fetchQuery = fetchQuery.replace(
           "ORDER BY body_part.id DESC",
           "ORDER BY body_part.id ASC",
       )
    let [records] = await db.query(fetchQuery);
    const totalRecord = await countQueryCondition(fetchQuery);
    return sendResponse(res, 200, records, totalRecord);
  };


  