import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  countQueryCondition,
  whereCondition,
  searchConditionRecord,
  makeJoins,
  insertActivityLog,
  deleteRecord,
  updateQueryBuilder,
  createQueryBuilder,
  decodeAndParseFields,
  uploadFile,
  getRecord,
  processUploadDocuments,
  uniqueIdGenerator,
} from "../helper/general.js";
import ContractorTrainingAttendance from "../sequelize/ContractorTrainingAttendanceSchema.js";
import { uploadToDDRM } from "../helper/ddrmUploader.js";
import ContractorAttendanceDocs from "../sequelize/ContractorAttendanceDocsSchema.js";

export const createUpdateContractorTrainingAttendance = async (req, res) => {
  req.body = (await decodeAndParseFields([req.body]))[0];
  const { id, sidebar_id = 294 } = req.body;

  console.log(">>>>>>>>", req.body);

  const [fetchOrganization] = await db.query(
    `SELECT organization , department FROM contractor_training_schedule WHERE id = ${req.body.training_program}`
  );

  req.body.organization = fetchOrganization[0]?.organization;
  req.body.department = fetchOrganization[0]?.department;

  if (id) {
    await deleteRecord(ContractorAttendanceDocs, id, "attendance_recording_id");
  }

  const documents = await processUploadDocuments(req, sidebar_id);

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;

  // console.log("-------- req.body.department ", req.body.department )

  if (!id) {
    const unique_id = await uniqueIdGenerator(
      req.body.organization,
      req.body.department,
      "ContractorTrainingAttendance",
      "contractor_attendance_recording",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
  }

  const { query, values } = id
    ? updateQueryBuilder(ContractorTrainingAttendance, req.body)
    : createQueryBuilder(ContractorTrainingAttendance, req.body);
  let [result] = await db.query(query, values);
  console.log(documents);
  for (const doc of documents) {
    const { query, values } = createQueryBuilder(ContractorAttendanceDocs, {
      attendance_recording_id: id ? id : result.insertId,
      ...doc,
    });
    // console.log(query, values);
    await db.query(query, values);
  }

  await insertActivityLog(
    req.user.sessionid,
    "update",
    `ContractorTrainingAttendance Record is updated for this organization ${req.body.organization}`,
    id
  );
  return sendResponse(res, 200, `Record ${status} successfully`);
};

export const getContractorTrainingAttendance = async (req, res) => {
  const { id } = req.params;
  const condition = await whereCondition({
    table: "contractor_attendance_recording",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    grouped: req.query.grouped,
    user: req.user,
  });

  const searchTableName = [
    "contractor_attendance_recording.actual_training_service_provider",
    "contractor_attendance_recording.training_venue",
  ];

  const searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  const joins = [
    {
      type: "left",
      targetTable: "training_schedule",
      onCondition:
        "training_schedule.id = contractor_attendance_recording.training_program",
    },
    {
      type: "left",
      targetTable: "training_need_analysis",
      onCondition:
        "training_need_analysis.id = training_schedule.training_program",
    },
    {
      type: "left",
      targetTable: "purpose_of_training",
      onCondition:
        "purpose_of_training.id = training_need_analysis.training_purpose",
    },
    // {
    //   type: "left",
    //   targetTable: "contractor_registration",
    //   onCondition:
    //     "contractor_registration.id = contractor_attendance_recording.company",
    // },
    {
      type: "left",
      targetTable: "users as employee",
      onCondition: "employee.id = contractor_attendance_recording.employee",
    },
    {
      type: "left",
      targetTable: "currency",
      onCondition: "currency.id = contractor_attendance_recording.currency",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition:
        "contractor_attendance_recording.organization = organization.id",
    },
  ];

  const joinCondition = await makeJoins(joins);

  const contractorAttendanceRecordingQuery = `SELECT 
    contractor_attendance_recording.* , CONCAT(employee.name, ' ', employee.surname) as employee_name , training_need_analysis.training_name AS training_program_name  , training_need_analysis.training_purpose , training_need_analysis.training_type , organization.name AS organization_name FROM contractor_attendance_recording ${joinCondition} WHERE contractor_attendance_recording.deleted = 0 ${searchCondition} ${condition}`;

  let [contractorAttendanceRecording] = await db.query(
    contractorAttendanceRecordingQuery
  );
  // console.log('contractorAttendanceRecordingQuery: ', contractorAttendanceRecordingQuery);
  // console.log('contractorAttendanceRecording: ', contractorAttendanceRecording);
  contractorAttendanceRecording = await decodeAndParseFields(
    contractorAttendanceRecording
  );

  for (const record of contractorAttendanceRecording) {
    const contractors = record.contractors;
    record.contractor_details = [];
    if (contractors && contractors.length > 0) {
      for (const contractor of contractors) {
        const [contractorDetails] = await db.query(
          `SELECT * FROM contractor_registration WHERE id = ${contractor}`
        );
        record.contractor_details.push({
          contractor_name: contractorDetails[0]?.contractor_name,
          contractor_cipc_registration_number:
            contractorDetails[0]?.cipc_registration_number,
        });
      }
    }
    const projects = record.projects;
    record.project_details = [];
    if (projects && projects.length > 0) {
      for (const project of projects) {
        const [projectDetails] = await db.query(
          `SELECT * FROM project_registration WHERE id = ${project}`
        );
        record.project_details.push({
          project_name: projectDetails[0]?.project_title,
        });
      }
    }

    const [files] = await db.query(
      `SELECT contractor_training_attendance_docs.*, repository.url as file, document_creation.document_name as title FROM contractor_training_attendance_docs LEFT JOIN repository ON repository.id = contractor_training_attendance_docs.ddrm_id LEFT JOIN document_creation ON document_creation.id = repository.document_creation_id WHERE contractor_training_attendance_docs.deleted = 0 AND attendance_recording_id = ${record.id}`
    );

    record.upload_documents = files;
  }
  const totalRecord = await countQueryCondition(
    contractorAttendanceRecordingQuery
  );

  return sendResponse(res, 200, contractorAttendanceRecording, totalRecord);
};

export const deleteContractorTrainingAttendance = async (req, res) => {
  const { id } = req.params;
  await deleteRecord("contractor_attendance_recording", id);
  await insertActivityLog(
    req.user.sessionid,
    "delete",
    "ContractorTrainingAttendance Record has been deleted by this user",
    id
  );
  return sendResponse(res, 200, "Record deleted successfully");
};
