import db from "../db-config.js";

import {
  countQueryCondition,
  createQueryBuilder,
  decodeAndParseFields,
  deleteRecord,
  encodeAndStringifyFields,
  getOrganizationAccordingToDepartment,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  uniqueIdGenerator,
  updateQueryBuilder,
  uploadFile,
  whereCondition,
} from "../helper/general.js";

import { sendResponse } from "../helper/wrapper.js";
import ContractorSafeWorking from "../sequelize/ContractorSafeWorkingSchema.js";
import sendEmail from "../helper/sendEmail.js";
import ContractorSafeWorkingDocs from "../sequelize/ContractorSafeWorkingDocsSchema.js";

export const createUpdateContractorSafeWorking = async (req, res) => {
  const { id, contractor } = req.body;
  if (req.files) {
    const doc = req.files.document;
    if (doc) req.body.document = await uploadFile("contractor_safe_working", doc);
  }
  let document = [];
  for (let i = 0; i <= 10; i++) {
    if (req.body[`upload_documents[${i}].file`] || (req.files && req.files[`upload_documents[${i}].file`])) {
      const file = req.files && req.files[`upload_documents[${i}].file`];
      if (typeof file != "string" && typeof file == "object") {
        const filePath = await uploadFile("contractor_safe_working", file);
        document.push({ file: filePath, doc_no: i });
      } else {
        document.push({
          file: req.body[`upload_documents[${i}].file`],
          doc_no: i,
        });
      }
    }
  }
  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;

  const [check] = await db.query(
    `SELECT * FROM contractor_safe_working WHERE contractor = ${contractor} AND deleted = 0`
  );
  const [fetchOrg] = await db.query(`SELECT * FROM contractor_registration WHERE id = ${contractor}`);
  req.body.organization = fetchOrg[0]?.organization;
  req.body.department = fetchOrg[0]?.department;

  req.body = await encodeAndStringifyFields(req.body);

  if (!id) {
    const unique_id = await uniqueIdGenerator(
      req.body.organization,
      req.body.department,
      "ContractorSafeWorking",
      "contractor_safe_working",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
  }

  const { query, values } = id
    ? updateQueryBuilder(ContractorSafeWorking, req.body)
    : createQueryBuilder(ContractorSafeWorking, req.body);
  const [result] = await db.query(query, values);

  req.body.public_url = `/safe-working-application/fill/${id ? id : result.insertId}`;
  await db.query(
    `UPDATE contractor_safe_working SET public_url = '${req.body.public_url}' WHERE id = ${id ? id : result.insertId}`
  );
  if (id) {
    await deleteRecord(ContractorSafeWorkingDocs, id, "contractor_safe_working_id");
  }

  if (document.length > 0) {
    for (const doc of document) {
      const { query, values } = createQueryBuilder(ContractorSafeWorkingDocs, {
        ...doc,
        contractor_safe_working_id: id ? id : result.insertId,
      });
      await db.query(query, values);
    }
  }
  await insertActivityLog(req.user.sessionid, status, "Contractor SafeWorking", id ? id : result.insertId);
  // send email

  return sendResponse(res, 200, `Record ${status} Successfully`);
};

export const getContractorSafeWorking = async (req, res) => {
  const { id } = req.params;
  const condition = await whereCondition({
    table: "contractor_safe_working",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    grouped: req.query.grouped,
    user: req.user,
  });

  const searchTableName = ["contractor_registration.contractor_name","contractor_safe_working.signing_method", "CONCAT(users.name , ' ' , users.surname)"];

  const searchCondition = await searchConditionRecord(req.query.search, searchTableName);

  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = contractor_safe_working.created_by",
    },
    {
      type: "left",
      targetTable: "contractor_registration",
      onCondition: "contractor_registration.id = contractor_safe_working.contractor",
    },
    {
      type: "left",
      targetTable: "project_registration",
      onCondition: "project_registration.id = contractor_safe_working.project",
    },
  ];

  const joinCondition = await makeJoins(joins);

  const contractorSafeWorkingQuery = `SELECT contractor_safe_working.* , CONCAT(users.name , ' ' , users.surname) AS created_by_name , contractor_registration.contractor_name AS contractor_name , project_registration.project_title AS project_name FROM contractor_safe_working ${joinCondition} WHERE contractor_safe_working.deleted = 0 ${searchCondition} ${condition}`;

  let [contractorSafeWorking] = await db.query(contractorSafeWorkingQuery);

  contractorSafeWorking = await decodeAndParseFields(contractorSafeWorking);
  for (const element of contractorSafeWorking) {
    const id = element.id;
    const [docs] = await db.query(
      `SELECT * FROM contractor_safe_working_docs WHERE contractor_safe_working_id = ${id} AND deleted = 0`
    );
    element.upload_documents = docs;
  }

  const totalRecord = await countQueryCondition(contractorSafeWorkingQuery);

  return sendResponse(res, 200, contractorSafeWorking, totalRecord);
};

export const deleteContractorSafeWorking = async (req, res) => {
  const { id } = req.params;

  await deleteRecord(ContractorSafeWorking, id);
  await insertActivityLog(req.user.sessionid, "delete", "Contractor SafeWorking", id);

  return sendResponse(res, 200, "Record deleted successfully");
};

export const sendSafeWorking = async (req, res) => {
  const { id, url } = req.body;
  const [dataFetch] = await db.query(
    `SELECT contractor_safe_working.* , cr.contractor_name AS contractor_name , cr.email AS email  FROM contractor_safe_working LEFT JOIN contractor_registration  as cr ON cr.id = contractor_safe_working.contractor WHERE contractor_safe_working.id = ${id}`
  );

  const name = dataFetch[0]?.contractor_name;
  const email = dataFetch[0]?.email;
  const link = url;

  const sendRecordArray = {
    templateFileUrl: "mail_for_safe_working_template.html",
    link: link,
    name: name,
    templateName: "Safe Working",
  };

  const info = await sendEmail("info@harmonyandhelp.com", email, "SafeWorking Response", sendRecordArray);

  if (info) {
    return sendResponse(res, 200, "SafeWorking sent to email successfully");
  } else return sendResponse(res, 400, "SafeWorking sending failed. Please try again");
};

// export const enableDisableForm =

export const fillForm = async (req, res) => {
  let { id, form } = req.body;
  if (!id) {
    return sendResponse(res, 400, "Please provide id");
  }
  const [check] = await db.query(`SELECT * FROM contractor_safe_working WHERE id = ${id}`);
  form = typeof form == "string" ? JSON.parse(form) : form;
  let contractor = form.contractor;

  const [result] = await db.query(`UPDATE contractor_safe_working SET form = ? , contractor = ?  WHERE id =? `, [
    JSON.stringify(form),
    contractor,
    id,
  ]);

  if (result.affectedRows > 0) {
    return sendResponse(res, 200, "Form submitted successfully");
  }
  return sendResponse(res, 400, "Record Not updated");
};

export const uploadDocument = async (req, res) => {
  const { id, ddrm_id } = req.body;
  // let document = "";
  // if (req.files) {
  //   const file = req.files.document;
  //   console.log(req.files);
  //   console.log(document);
  //   document = await uploadFile("contractor_safe_working", file);
  // } else {
  //   document = req.body.document;
  // }

  const [result] = await db.query(`UPDATE contractor_safe_working SET ddrm_id = ? WHERE id = ?`, [ddrm_id, id]);

  if (result.affectedRows > 0) {
    return sendResponse(res, 200, "Document uploaded successfully");
  }
  return sendResponse(res, 400, "Error updating document");
};
