import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  settingsUpdater,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  getFirstCreatedAndAllOrganizationIds,
  uniqueIdGenerator,
  encodeAndStringifyFields,
  updateQueryBuilder,
  createQueryBuilder,
  getFilterConditions,
  getListingData,
} from "../helper/general.js";
import ControlType from "../sequelize/ControlTypeSchema.js";

/** Function to create or update ControlType */
export const createUpdateControlType = async (req, res) => {
  const { id, organization } = req.body;

  if (id && organization.length === 0) {
    return sendResponse(res, 404, "Please Select at least one business Structure");
  }

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "ControlType",
      "control_type",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization = organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id ? updateQueryBuilder(ControlType, req.body) : createQueryBuilder(ControlType, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(req.user.sessionid, status, "ControlType", id ? id : result.insertId);
  return sendResponse(res, 200, `Record ${status} Successfully`);
};
// export const createUpdateControlType = async (req, res) => {
//   const { id, name, description } = req.body;
//   const encodedDescription = await encodeSingle_statement(description);

//   if (id) {
//     const result = await settingsUpdater(
//       ControlType,
//       req.body.organization,
//       req.body,
//       req.user
//     );
//     if (!result) {
//       return sendResponse(res, 404, "No data found");
//     }
//     await insertActivityLog(req.user.sessionid, "update", "ControlType", `This user updated ControlType with id: ${id}`);
//     return sendResponse(res, 200, "Record updated successfully");
//   } else {
//     const insertPromises = req.body.organization.map(async (org) => {
//       const [checkName] = await db.query(`SELECT name FROM control_type WHERE name = ? AND deleted = 0 AND organization = ?`, [name, org]);
//       if (checkName.length === 0) {
//         await db.query(`INSERT INTO control_type (name, description, created_by, organization) VALUES (?, ?, ?, ?)`, [name, encodedDescription, req.user.sessionid, org]);
//         await insertActivityLog(req.user.sessionid, "create", "ControlType", `This user created a new ControlType '${name}' for organization ${org}`);
//       }
//     });
//     await Promise.all(insertPromises);
//     return sendResponse(res, 200, "Record created successfully");
//   }
// };

/** Function to view all or single ControlType */
export const viewControlType = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(req, db, "control_type");

  // const { id } = req.params;
  // const condition = await whereCondition({
  //   table: "control_type",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  const searchFields = ["control_type.name", "control_type.description", "users.name", "organization.name"];
  let searchCondition = await searchConditionRecord(req.query.search, searchFields);
  const joins = [
    { type: "left", targetTable: "users", onCondition: "users.id = control_type.created_by" },
    // { type: "left", targetTable: "organization", onCondition: "organization.id = control_type.organization" }
  ];
  const joinsRecord = await makeJoins(joins);

  const fetchQuery = `SELECT control_type.*, CONCAT(users.name, ' ', users.surname) AS created_by, control_type.organization AS organizations FROM control_type ${joinsRecord} WHERE control_type.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;
  let [records] = await db.query(fetchQuery);

  records = await getListingData(records);
  // for (const record of records) {
  //   record.description = await decodeSingle_statement(record.description);
  //    if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM control_type WHERE deleted = 0 AND name = ?`,
  //       [record.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     record.organizations = arr;
  //   }
  // }

  const totalRecord = await countQueryCondition(fetchQuery);
  return sendResponse(res, 200, records, totalRecord);
};

/** Function to delete ControlType */
export const deleteControlType = async (req, res) => {
  const { id } = req.params;
  const deleteRecord = await deleteSettingRecord("control_type", id);
  if (deleteRecord) {
    await insertActivityLog(req.user.sessionid, "delete", "ControlType", id);
    return sendResponse(res, 200, "Record deleted successfully");
  } else {
    return sendResponse(res, 404, "Record not found");
  }
};
