import db from "../db-config.js";
import {
  checkNameAlreadyExits,
  checkNameInOrganization,
  countQueryCondition,
  createQueryBuilder,
  decodeSingle_statement,
  deleteSettingRecord,
  encodeSingle_statement,
  insertActivityLog,
  makeJoins,
  recordIdExist,
  searchConditionRecord,
  settingsUpdater,
  uniqueIdGenerator,
  whereCondition,
} from "../helper/general.js";
import { sendResponse } from "../helper/wrapper.js";

import Department from "../sequelize/DepartmentSchema.js";

/**Function to create new department  */
export const createUpdateDepartment = async (req, res) => {
  const { id, name, description, organization, head } = req.body;

  const encodedDescription = await encodeSingle_statement(description);
  req.body.description = encodedDescription;

  /**If id comes in body then it will update the query */
  if (id) {
    req.body.department_head = req.body.head;
    if (organization.length === 0) {
      return sendResponse(res, 400, "Please Select at least one business Structure");
    }

    const result = await settingsUpdater(Department, organization, req.body, req.user);

    if (!result) {
      return sendResponse(res, 404, "No data found");
    }
    /**Insert Activity  */
    await insertActivityLog(req.user.sessionid, "update", "Department", id);

    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const insertPromises = organization.map(async (element) => {
      /**Check that this organization have that particular name or not*/
      const checkNameWithOrganization = await checkNameInOrganization("department", name, element);

      console.log("body", req.body);
      console.log("checkNameWithOrganization", checkNameWithOrganization);

      if (checkNameWithOrganization.length === 0) {
        /**Insert record for Department */
        req.body.department_head = head;
        req.body.created_by = req.user.sessionid;
        req.body.organization = element;
        if (req.body.parent_department) {
          const [checkName] = await db.query(`SELECT name FROM department WHERE id = ${req.body.parent_department}`);
          const [newParent] = await db.query(
            `SELECT id FROM department WHERE name  = '${checkName[0].name}' AND organization = ${element}`
          );
          req.body.parent_department = newParent[0].id;
        }

        if (!id) {
          const unique_id = await uniqueIdGenerator(
            element,
            null,
            "Department",
            "department",
            "unique_id",
            "unique_id"
          );
          console.log("unique_id", unique_id);
          req.body.unique_id = unique_id;
        }

        const { query, values } = createQueryBuilder(Department, {
          ...req.body,
          organization: element,
        });

        const [createDepartment] = await db.query(query, values);

        /**Insert record for activity log */
        await insertActivityLog(req.user.sessionid, "create", "Department", createDepartment.insertId);
      }
    });
    await Promise.all(insertPromises);
  }
  return sendResponse(res, 200, "Record created successfully");
};

/** Function to view all and single Department */
export const viewDepartment = async (req, res) => {
  const { id } = req.params;
  const condition = await whereCondition({
    table: "department",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id: id,
    user: req.user,
    grouped: req.query.grouped,
  });
  const searchTableName = ["department.name", "department.description", "organization.name"];
  let searchCondition = await searchConditionRecord(req.query.search, searchTableName);

  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users u1",
      onCondition: "u1.id = department.created_by",
    },
    {
      type: "left",
      targetTable: "users u2",
      onCondition: "u2.id = department.department_head",
    },
    {
      type: "left",
      targetTable: "department as parent_department",
      onCondition: "parent_department.id = department.parent_department",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition: "organization.id = department.organization",
    },
  ];

  const joinsRecord = await makeJoins(joins);

  const query = `SELECT organization.name as organization_name , department.id,department.unique_id,department.department_head,department.created_by as created_by_id,department.name,department.description,department.organization,
    department.parent_department,
    parent_department.name as parent_department_name,
    u1.name as created_by, u1.surname as created_by_surname , u1.profile as created_by_profile,
    u2.name as department_head_name , u2.surname as department_head_surname ,u2.profile as department_head_profile

    FROM department ${joinsRecord} where department.deleted = 0 ${searchCondition} ${condition}`;
  const [getData] = await db.query(query);
  //   console.log(query);

  // getData.forEach(async (data) => {
  //   data.description = await decodeSingle_statement(data.description);
  // });

  for (const data of getData) {
    data.description = await decodeSingle_statement(data.description);
    if (req.query.grouped == "true") {
      const [organizations] = await db.query(`SELECT organization FROM department WHERE deleted = 0 AND name = ?`, [
        data.name,
      ]);
      const arr = organizations.map((item) => item.organization);
      data.organizations = arr;
    }
  }

  const totalRecord = await countQueryCondition(query);

  return sendResponse(res, 200, getData, totalRecord);
};

// /**Function to delete a specific Department */
export const deleteDepartment = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteSettingRecord("department", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    await insertActivityLog(req.user.sessionid, "delete", "Department", id);
    return sendResponse(res, 200, "Record deleted successfully");
  }
};

/**Function to get list of all employee according to that department */
export const listOfEmployeeAccordingToDepartment = async (req, res) => {
  /**Get list of all department  */
  const condition = await whereCondition({
    table: "department",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id: req.params.id,
    grouped: req.query.grouped,
    user: req.user,
  });

  const [departmentsDataFetch] = await db.query(
    `SELECT department.id,department.name FROM department WHERE department.deleted = "0" ${condition}`
  );

  /**Get Record of all that employee who have in department according to that id */
  for (const team of departmentsDataFetch) {
    const teamsMembersQuery = `SELECT users.id,CONCAT(users.name , ' ' , users.surname) AS name,roles.name AS role_name ,users.profile  FROM users LEFT JOIN roles ON roles.id = users.role WHERE users.department = ${team.id}`;
    // return console.log(teamsMembersQuery);
    const [teamsMembers] = await db.query(teamsMembersQuery);
    team.members = teamsMembers;
  }
  const result = departmentsDataFetch;

  return sendResponse(res, 200, result);
};

/**function to import department */
export const importDepartmentData = async (req, res) => {
  const { organization, data } = req.body;
  const alreadyExistData = [];

  for (let i = 0; i < data.length; i++) {
    let department = data[i];
    const { name, description, head } = department;
    // Check if the department already exists
    const departmentCheck = await checkNameAlreadyExits("department", "name", name, organization);

    /** Check if department dependent data exists or not */
    const organizationCheck = await recordIdExist("organization", organization);

    if (departmentCheck) {
      alreadyExistData.push({
        message: `Department already exists at index ${i + 1}`,
      });
    } else if (!organizationCheck) {
      alreadyExistData.push({
        message: `Organization not found at index ${i + 1}`,
      });
    } else {
      req.body.created_by = req.user.sessionid;
      const { query, values } = createQueryBuilder(Department, req.body);
      const createDepartment = await db.query(query, values);

      /**Insert record for activity log */
      await insertActivityLog(req.user.sessionid, "create", "Department", createDepartment.insertId);
    }
  }
  if (alreadyExistData.length > 0) {
    return sendResponse(res, 500, "Record created successfully", alreadyExistData);
  } else {
    return sendResponse(res, 200, "Record created successfully", alreadyExistData);
  }
};

/**Function TO filter parent Department List for selection */

export const getParentDepartmentList = async (req, res) => {
  let { organizations } = req.query;
  organizations = JSON.parse(organizations);
  const parentDepartmentQuery = `SELECT r1.*
FROM department r1
JOIN (
    SELECT name
    FROM department
    WHERE organization IN (${organizations})  
    GROUP BY name
    HAVING COUNT(DISTINCT organization) = ${organizations.length}
) r2 ON r1.name = r2.name
WHERE r1.organization IN (${organizations});
`;
  // console.log(parentDepartmentQuery, "parentDepartmentQuery");
  const [parentDepartmentList] = await db.query(parentDepartmentQuery);
  const uniqueObj = {};
  parentDepartmentList.forEach((item) => {
    if (!uniqueObj[item.name]) {
      uniqueObj[item.name] = item;
    }
  });
  const uniqueArr = Object.values(uniqueObj);
  //  return uniqueArr;
  return sendResponse(res, 200, uniqueArr);
};

export const getEmployeeListForDepartment = async (req, res) => {
  let { organizations } = req.query;
  organizations = JSON.parse(organizations);
  const departmentHeadQuery = `SELECT r1.*
FROM users r1
JOIN (
    SELECT name
    FROM users
    WHERE my_organization IN (${organizations})  
    GROUP BY name
    HAVING COUNT(DISTINCT organization) = ${organizations.length}
) r2 ON r1.name = r2.name
WHERE r1.my_organization IN (${organizations});
`;
  // console.log(departmentHeadQuery, "departmentHeadQuery");
  const [departmentHeadList] = await db.query(departmentHeadQuery);
  // console.log(departmentHeadList, "departmentHeadList");

  return sendResponse(res, 200, departmentHeadList);
};
