import db from "../db-config.js";
import {
  countQueryCondition,
  decodeSingle_statement,
  deleteSettingRecord,
  encodeSingle_statement,
  insertActivityLog,
  makeJoins,
  whereCondition,
  settingsUpdater,
  searchConditionRecord,
  createQueryBuilder,
  encodeAndStringifyFields,
  uniqueIdGenerator,
  getRecord,
  getFirstCreatedAndAllOrganizationIds,
  getFilterConditions,
  getListingData,
} from "../helper/general.js";
import DocumentType from "../sequelize/DocumentTypeSchema.js";
import { sendResponse } from "../helper/wrapper.js";
import { updateQueryBuilder } from "../helper/queryBuilder.js";

/**Function to create new Document Type  */
export const createUpdateDocumentType = async (req, res) => {
  let { id, description, organization, department,name } = req.body;

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "DocumentType",
      "document_type",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization =
      organization.length > 0 ? organization : result.organizationIds;
  }
  const encodedDescription = await encodeSingle_statement(description);
  req.body.description = encodedDescription;
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  /**If id comes in body then it will update the query */
  const [checkNameWithOrganization] = await getRecord(
    "document_type",
    "name",
    name
  );
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(res, 400, "DocumentType name already exist");
    } else if (!id) {
      return sendResponse(res, 400, "DocumentType name name  already exist");
    }
  }
  if (id) {
    /**Check that this organization have that particular name or not*/
    if (organization.length === 0) {
      return sendResponse(
        res,
        400,
        "Please Select at least one business Structure"
      );
    }

    /**update query */
    const { query, values } = updateQueryBuilder(DocumentType, req.body);
    await db.query(query, values);
    /**Update record for activity log */
    await insertActivityLog(req.user.sessionid, "update", "DocumentType", id);
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const { query, values } = createQueryBuilder(DocumentType, req.body);
    const result = await db.query(query, values);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "DocumentType",
      result.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  }

  // req.body = await encodeAndStringifyFields(req.body);

  // req.body[req.body.id ? "updated_by" : "created_by"] = req.user.sessionid;

  // /**If id comes in body then it will update the query */
  // if (id) {
  //   if (organization.length === 0) {
  //     return sendResponse(
  //       res,
  //       404,
  //       "Please Select at least one business Structure"
  //     );
  //   }
  //   const result = await settingsUpdater(
  //     DocumentType,
  //     organization,
  //     req.body,
  //     req.user
  //   );
  //   if (!result) {
  //     return sendResponse(res, 404, "No data found");
  //   }

  //   await insertActivityLog(
  //     req.user.sessionid,
  //     "update",
  //     "Document type",
  //     `This user Update Document type which id is ${id}`
  //   );

  //   return sendResponse(res, 200, "Record updated successfully");
  // } else {
  //   const unique_id = await uniqueIdGenerator(
  //     organization,
  //     department,
  //     "DT",
  //     "document_type",
  //     "unique_id",
  //     "unique_id"
  //   );
  //   req.body.unique_id = unique_id;
  //   const insertPromises = organization.map(async (element) => {
  //     // Check if the category type already exists for the organization
  //     const [checkNameWithOrganization] = await db.query(
  //       `SELECT name FROM document_type WHERE name = ? AND deleted = "0" AND organization = ?`,
  //       [req.body.name, element]
  //     );
  //     if (req.body.parent) {
  //       const [checkName] = await db.query(
  //         `SELECT name FROM document_type WHERE id = ${req.body.parent}`
  //       );
  //       const [newParent] = await db.query(
  //         `SELECT id FROM document_type WHERE name  = '${checkName[0].name}' AND organization = ${element}`
  //       );
  //       req.body.parent = newParent[0].id;
  //     }

  //     req.body.organization = element;
  //     console.log(req.body);
  //     if (checkNameWithOrganization.length === 0) {
  //       const { query, values } = createQueryBuilder(DocumentType, {
  //         ...req.body,
  //         organization: element,
  //       });
  //       console.log(query, values);
  //       await db.query(query, values);

  //       // Insert record for activity log
  //       await insertActivityLog(
  //         req.user.sessionid,
  //         "create",
  //         "Document type",
  //         `This user created a new illness'${req.body.name}' for this organization ${element}`
  //       );
  //     }
  //   });

  //   await Promise.all(insertPromises);

  //   return sendResponse(res, 200, "Record created successfully");
  // }
};

/**Function to view all and single Incident Category */
export const viewDocumentType = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "document_type"
  );
  /** If value come with any search condition then search that word */
  const searchTableName = [
    "document_type.name",
    "document_type.description",
    "createdUser.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );
  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = document_type.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);
  /**Record of all Skill */
  let documentTypeQuery = `SELECT 
  document_type.*, 
  document_type.organization AS organizations, 
  createdUser.name AS created_by, 
  createdUser.surname AS created_by_surname, 
  createdUser.id AS created_by_id, 
  createdUser.profile AS created_by_profile
FROM document_type
${joinsRecord} 
WHERE document_type.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  // console.log(skillQuery, "skillQuery");
  let [documentType] = await db.query(documentTypeQuery);
  documentType = await getListingData(documentType);
  /**Count all organization */
  const totalRecord = await countQueryCondition(documentTypeQuery);
  return sendResponse(res, 200, documentType, totalRecord);

  // const { id } = req.params;
  // const { dropdown } = req.query;
  // const condition = await whereCondition({
  //   table: "document_type",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   grouped: req.query.grouped,
  //   user: req.user,
  // });

  // const searchTableName = [
  //   "document_type.name",
  //   "document_type.description",
  //   "CONCAT(users.name , ' ' , users.surname)",
  //   "organization.name",
  // ];
  // let searchCondition = await searchConditionRecord(
  //   req.query.search,
  //   searchTableName
  // );

  // const joins = [
  //   {
  //     type: "left",
  //     targetTable: "users",
  //     onCondition: "users.id = document_type.created_by",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "organization",
  //     onCondition: "organization.id = document_type.organization",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "document_type AS parent_document_type",
  //     onCondition: "parent_document_type.id = document_type.parent",
  //   },
  // ];
  // const joinsRecord = await makeJoins(joins);

  // const DocumentTypeQuery = `SELECT document_type.id, document_type.unique_id, document_type.created_by as created_by_id, document_type.name,parent_document_type.name AS parent_name , document_type.description, users.name as created_by, users.surname as created_by_surname, users.profile as created_by_profile, organization.name as organization_name, document_type.organization, document_type.parent FROM document_type ${joinsRecord} WHERE document_type.deleted = 0 ${searchCondition} ${condition}`;
  // const [DocumentType] = await db.query(DocumentTypeQuery);

  // async function fetchSubChildren(parentId) {
  //   const [subChildren] = await db.query(
  //     `SELECT * FROM document_type WHERE deleted = 0 AND parent = ?`,
  //     [parentId]
  //   );

  //   // Only populate sub-children if any are found, and no need to recurse if not needed
  //   for (const child of subChildren) {
  //     child.description = await decodeSingle_statement(child.description);
  //     child.sub_children = []; // Leave empty if no further children
  //   }
  //   return subChildren;
  // }

  // // Map through DocumentType and only populate the parent along with its sub-children.
  // const nestedDocumentTypes = [];

  // for (const item of DocumentType) {
  //   item.description = await decodeSingle_statement(item.description);

  //   // Fetch the nested sub_children only for the top-level items.
  //   if (item.parent === null) {
  //     // Populate organizations for grouped data
  //     if (req.query.grouped == "true") {
  //       const [organizations] = await db.query(
  //         `SELECT organization FROM document_type WHERE deleted = 0 AND name = ?`,
  //         [item.name]
  //       );
  //       const arr = organizations.map((item) => item.organization);
  //       item.organizations = arr;
  //     }

  //     // Fetch and add sub-children to the current Document type
  //     item.sub_children = await fetchSubChildren(item.id);
  //     nestedDocumentTypes.push(item); // Push only the parent with its nested structure
  //   } else if (dropdown != 1 || id) {
  //     nestedDocumentTypes.push(item);
  //   }
  // }

  // const totalRecord = await countQueryCondition(DocumentTypeQuery);
  // return sendResponse(res, 200, nestedDocumentTypes, totalRecord);
};

/**Function to delete a specific Incident Category */
export const deleteDocumentType = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteSettingRecord("document_type", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    await insertActivityLog(req.user.sessionid, "delete", "document_type", id);
    return sendResponse(res, 200, "Record deleted successfully");
  }
};

export const getParentDocumentTypeList = async (req, res) => {
  let { filter } = req.query;
  filter = typeof filter === "string" ? JSON.parse(filter) : filter;
  let { organizations } = filter;
  if (!organizations || organizations.length == 0) {
    const [arrOrg] = await db.query(
      `SELECT id FROM organization WHERE deleted = 0`
    );
    organizations = arrOrg.map((item) => item.id);
    // return sendResponse(res, 400, "organizations is required");
  }
  // console.log(organizations);
  organizations =
    typeof organizations == "string"
      ? JSON.parse(organizations)
      : organizations;
  const parentDocumentTypeQuery = `SELECT r1.*
FROM document_type r1
JOIN (
   SELECT name
   FROM document_type
   WHERE organization IN (${organizations})
   GROUP BY name
   HAVING COUNT(DISTINCT organization) = ${organizations.length}
)  r2 ON r1.name = r2.name
WHERE r1.organization IN (${organizations}) AND r1.deleted = 0;
`;
  // console.log(parentDocumentTypeQuery, "parentDocumentTypeQuery")
  const [parentDocumentTypeList] = await db.query(parentDocumentTypeQuery);
  const uniqueObj = {};
  parentDocumentTypeList.forEach((item) => {
    if (!uniqueObj[item.name]) {
      uniqueObj[item.name] = item;
    }
  });
  const uniqueArr = Object.values(uniqueObj);
  // console.log(uniqueArr);
  // return uniqueArr;

  return sendResponse(res, 200, uniqueArr);
};
