import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  settingsUpdater,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  uniqueIdGenerator,
  createQueryBuilder,
  updateQueryBuilder,
  encodeAndStringifyFields,
  getFirstCreatedAndAllOrganizationIds,
  getFilterConditions,
  getListingData,
} from "../helper/general.js";
import FileClassification from "../sequelize/FileClassificationSchema.js";

/** Function to create or update FileClassification */
export const createUpdateFileClassification = async (req, res) => {
  const { id, organization } = req.body;

  if (id && organization.length === 0) {
    return sendResponse(res, 404, "Please Select at least one business Structure");
  }

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "FileClassification",
      "file_classification",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization = organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id
    ? updateQueryBuilder(FileClassification, req.body)
    : createQueryBuilder(FileClassification, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(req.user.sessionid, status, "FileClassification", id ? id : result.insertId);
  return sendResponse(res, 200, `Record ${status} Successfully`);
};
// export const createUpdateFileClassification = async (req, res) => {
//   const { id, name, description } = req.body;
//   const encodedDescription = await encodeSingle_statement(description);

//   if (id) {
//     const result = await settingsUpdater(
//       FileClassification,
//       req.body.organization,
//       req.body,
//       req.user
//     );
//     if (!result) {
//       return sendResponse(res, 404, "No data found");
//     }
//     await insertActivityLog(req.user.sessionid, "update", "FileClassification", `This user updated FileClassification with id: ${id}`);
//     return sendResponse(res, 200, "Record updated successfully");
//   } else {
//     const insertPromises = req.body.organization.map(async (org) => {
//       const [checkName] = await db.query(`SELECT name FROM file_classification WHERE name = ? AND deleted = 0 AND organization = ?`, [name, org]);
//       if (checkName.length === 0) {
//          const unique_id = await uniqueIdGenerator(
//             org,
//             req?.body?.department || null,
//             "FileClassification",
//             "file_classification",
//             "unique_id",
//             "unique_id"
//           );

//         await db.query(`INSERT INTO file_classification (name, description, created_by, organization,unique_id) VALUES (?,?, ?, ?, ?)`, [name, encodedDescription, req.user.sessionid, org,unique_id]);
//         await insertActivityLog(req.user.sessionid, "create", "FileClassification", `This user created a new FileClassification '${name}' for organization ${org}`);
//       }
//     });
//     await Promise.all(insertPromises);
//     return sendResponse(res, 200, "Record created successfully");
//   }
// };

/** Function to view all or single FileClassification */
export const viewFileClassification = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(req, db, "file_classification");

  // const { id } = req.params;
  // const condition = await whereCondition({
  //   table: "file_classification",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  const searchFields = [
    "file_classification.name",
    "file_classification.description",
    "users.name",
  ];
  let searchCondition = await searchConditionRecord(req.query.search, searchFields);
  const joins = [{ type: "left", targetTable: "users", onCondition: "users.id = file_classification.created_by" }];
  const joinsRecord = await makeJoins(joins);

  const fetchQuery = `SELECT file_classification.*, CONCAT(users.name, ' ', users.surname) AS created_by, file_classification.organization AS organizations FROM file_classification ${joinsRecord} WHERE file_classification.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;
  let [records] = await db.query(fetchQuery);

  records = await getListingData(records);

  // for (const record of records) {
  //   record.description = await decodeSingle_statement(record.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM file_classification WHERE deleted = 0 AND name = ?`,
  //       [record.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     record.organizations = arr;
  //   }
  // }

  const totalRecord = await countQueryCondition(fetchQuery);
  return sendResponse(res, 200, records, totalRecord);
};

/** Function to delete FileClassification */
export const deleteFileClassification = async (req, res) => {
  const { id } = req.params;
  const deleteRecord = await deleteSettingRecord("file_classification", id);
  if (deleteRecord) {
    await insertActivityLog(req.user.sessionid, "delete", "FileClassification", id);
    return sendResponse(res, 200, "Record deleted successfully");
  } else {
    return sendResponse(res, 404, "Record not found");
  }
};
