import db from "../db-config.js";

import {
  countQueryCondition,
  createQueryBuilder,
  decodeAndParseFields,
  deleteRecord,
  encodeAndStringifyFields,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  updateQueryBuilder,
  uploadFile,
  whereCondition,
} from "../helper/general.js";

import { sendResponse } from "../helper/wrapper.js";
import FinalHandover from "../sequelize/FinalHandoverSchema.js";
import sendEmail from "../helper/sendEmail.js";
import FinalHandoverResponseDocs from "../sequelize/FinalHandoverResponseDocsSchema.js";
import FinalHandoverResponses from "../sequelize/FinalHandoverResponsesSchema.js";
import chalk from "chalk";

export const createUpdateFinalHandover = async (req, res) => {
  const { id, contractors } = req.body;

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  if (contractors && Array.isArray(contractors)) {
    for (const contractor of contractors) {
      const [check] = await db.query(
        `SELECT * FROM final_handover WHERE contractor = ${contractor} AND deleted = 0`
      );
      if (check.length > 0) {
        continue;
      }
      const [fetchOrg] = await db.query(
        `SELECT * FROM contractor_registration WHERE id = ${contractors[0]}`
      );
      req.body.organization = fetchOrg[0]?.organization;
      req.body.department = fetchOrg[0]?.department;
      req.body.contractor = contractor;
      req.body.status = "Not Sent";
      req.body = await encodeAndStringifyFields(req.body);

      const { query, values } = id
        ? updateQueryBuilder(FinalHandover, req.body)
        : createQueryBuilder(FinalHandover, req.body);
      const [result] = await db.query(query, values);

      req.body.public_url = `final-handover/fill/${id ? id : result.insertId}`;
      await db.query(
        `UPDATE final_handover SET public_url = '${
          req.body.public_url
        }' WHERE id = ${id ? id : result.insertId}`
      );

      await insertActivityLog(
        req.user.sessionid,
        status,
        "Contractor FinalHandover",
        id ? id : result.insertId
      );
      // send email
    }
  }

  return sendResponse(res, 200, `Record ${status} Successfully`);
};

// export const getFinalHandover = async (req, res) => {
//   const { id } = req.params;
//   const condition = await whereCondition({
//     table: "final_handover",
//     page: req.query.page,
//     all: req.query.all,
//     pageSize: req.query.pageSize,
//     filter: req.query.filter,
//     id,
//     grouped: req.query.grouped,
//     user: req.user,
//   });

//   const searchTableName = [
//     "contractor_registration.contractor_name",
//     "CONCAT(users.name , ' ' , users.surname)",
//   ];

//   const searchCondition = await searchConditionRecord(
//     req.query.search,
//     searchTableName
//   );

//   const joins = [
//     {
//       type: "left",
//       targetTable: "users",
//       onCondition: "users.id = final_handover.created_by",
//     },
//     {
//       type: "left",
//       targetTable: "contractor_registration",
//       onCondition: "contractor_registration.id = final_handover.contractor",
//     },
//   ];

//   const joinCondition = await makeJoins(joins);

//   const contractorFinalHandoverQuery = `SELECT final_handover.* , CONCAT(users.name , ' ' , users.surname) AS created_by_name , contractor_registration.contractor_name AS contractor_name , contractor_registration.cipc_registration_number AS contractor_cipc_registration_number   FROM final_handover ${joinCondition} WHERE final_handover.deleted = 0 ${searchCondition} ${condition}`;

//   let [contractorFinalHandover] = await db.query(contractorFinalHandoverQuery);

//   contractorFinalHandover = await decodeAndParseFields(contractorFinalHandover);

//   for (const record of contractorFinalHandover) {
//     let [responses] = await db.query(
//       `SELECT * FROM final_handover_responses WHERE final_handover_id = ${record.id} AND deleted = 0`
//     );
//     responses = await decodeAndParseFields(responses);

//     // for (const response of responses) {
//     //   console.log(response);
//     //   const [docs] = await db.query(
//     //     `SELECT * FROM final_handover_responses_docs WHERE final_handover_response_id = ${response.id} AND deleted = 0`
//     //   );
//     //   console.log(response.contractor_final_handover_form);
//     //   const [form_template] = response?.contractor_final_handover_form
//     //     ? await db.query(
//     //         `SELECT * FROM contractor_forms WHERE id = ${response.contractor_final_handover_form}`
//     //       )
//     //     : null;
//     //   console.log(form_template);
//     //   form_template?.forEach((ele) => {
//     //     ele.form = ele?.form ? JSON.parse(ele.form) : ele.form;
//     //   });
//     //   response.form_template = form_template[0].form;

//     //   response.images = docs;
//     // }
//     for (const response of responses) {
//       response.form = Array.isArray(response.form)
//         ? response.form
//         : JSON.parse(response.form);
//       const [docs] = await db.query(
//         `SELECT * FROM final_handover_responses_docs WHERE final_handover_response_id = ${response.id} AND deleted = 0`
//       );
//       response.images = docs;
//     }
//     record.response_received = responses;
//   }

//   const totalRecord = await countQueryCondition(contractorFinalHandoverQuery);

//   return sendResponse(res, 200, contractorFinalHandover, totalRecord);
// };

export const getFinalHandover = async (req, res) => {
  const { id } = req.params;
  const condition = await whereCondition({
    table: "final_handover",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    grouped: req.query.grouped,
    user: req.user,
  });

  const searchTableName = [
    "contractor_registration.contractor_name",
    "CONCAT(users.name , ' ' , users.surname)",
  ];

  const searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = final_handover.created_by",
    },
    {
      type: "left",
      targetTable: "contractor_registration",
      onCondition: "contractor_registration.id = final_handover.contractor",
    },
    // {
    //   type: "left",
    //   targetTable: "project_registration",
    //   onCondition: "project_registration.id = final_handover.project",
    // },
  ];

  const joinCondition = await makeJoins(joins);

  const contractorQuestionnaireQuery = `SELECT final_handover.* , CONCAT(users.name , ' ' , users.surname) AS created_by_name , contractor_registration.contractor_name AS contractor_name , contractor_registration.cipc_registration_number AS contractor_cipc_registration_number FROM final_handover ${joinCondition} WHERE final_handover.deleted = 0 ${searchCondition} ${condition}`;

  let [contractorQuestionnaire] = await db.query(contractorQuestionnaireQuery);

  // contractorQuestionnaire = await decodeAndParseFields(contractorQuestionnaire);

  // console.log("contractorQuestionnaire------>",contractorQuestionnaire)

  for (const record of contractorQuestionnaire) {
    let [responses] = await db.query(
      `SELECT * FROM final_handover_responses WHERE final_handover_id = ${record.id} AND deleted = 0`
    );
    responses = await decodeAndParseFields(responses);
    // console.log(">>>>>>>>>>>>",responses)
    for (const response of responses) {
      const [docs] = await db.query(
        `SELECT * FROM final_handover_responses_docs WHERE final_handover_response_id = ${response.id} AND deleted = 0`
      );
      // let form_template = response.contractor_final_handover_form
      //   ? await db.query(
      //       `SELECT * FROM contractor_forms WHERE id = ${response.contractor_final_handover_form}`
      //     )
      //   : null;

      //   console.log("-form_template---",form_template)

      // if (form_template) {
      //   form_template[0]?.forEach((ele) => {
      //     ele.form = ele?.form ? JSON.parse(ele.form) : ele.form;
      //   });
      //   console.log("here====",form_template[0].form)
      //   response.form_template = form_template[0].form;
      //   // response.form = form_template[0].form;
      //   response.images = docs;

      //   response.contractor = record.contractor;
      //   response.contractor_name = record.contractor_name;
      //   response.contractor_cipc_registration_number = record.contractor_cipc_registration_number;
      //   response.organization = record.organization;
      //   response.unique_id = record.unique_id;
      // }

      // console.log("response?.contractor_final_handover_form",response?.contractor_final_handover_form)

      let form_template = response?.contractor_final_handover_form
        ? await db.query(
            `SELECT * FROM contractor_forms WHERE id = ${response.contractor_final_handover_form}`
          )
        : null;

      if (form_template) {
        form_template = form_template[0];
      }

      form_template?.forEach((ele) => {
        ele.form = ele?.form ? JSON.parse(ele.form) : ele.form;
      });
      // console.log(" form_template?.[0].form", form_template?.[0].form)
      response.unique_id - record?.unique_id;
      response.form_template = form_template?.[0]?.form;
      // response.form = form_template?.[0].form;
      response.images = docs;
      response.contractor = record.contractor;
      response.contractor_name = record.contractor_name;
      response.contractor_cipc_registration_number =
        record.contractor_cipc_registration_number;
      response.organization = record.organization;
      response.unique_id = record.unique_id;
    }
    // const id = record.id;
    record.response_received = responses;
  }

  const totalRecord = await countQueryCondition(contractorQuestionnaireQuery);

  return sendResponse(res, 200, contractorQuestionnaire, totalRecord);
};
export const deleteFinalHandover = async (req, res) => {
  const { id } = req.params;

  await deleteRecord(FinalHandover, id);
  await insertActivityLog(
    req.user.sessionid,
    "delete",
    "Contractor FinalHandover",
    id
  );

  return sendResponse(res, 200, "Record deleted successfully");
};

export const sendFinalHandover = async (req, res) => {
  const { id, url, name, contractor_final_handover_form, project } = req.body;
  const total = name.length;
  for (const i of name) {
    i.contractor_final_handover_form = contractor_final_handover_form;
    i.project = project;
    const { query, values } = createQueryBuilder(FinalHandoverResponses, {
      ...i,
      final_handover_id: id,
    });
    const [result] = await db.query(query, values);
    const link = url + "/" + result.insertId;

    const sendRecordArray = {
      templateFileUrl: "mail_for_final_handover_template.html",
      link: link,
      name: i.title,
      templateName: "Final Handover",
    };

    const info = await sendEmail(
      "info@harmonyandhelp.com",
      i.employee_email,
      "Final Handover Response",
      sendRecordArray
    );

    if (info) {
      await db.query(
        `UPDATE final_handover SET status = 'Response Pending' , total = ${total} , responses = 0 WHERE id = ${id}`
      );
    } else
      return sendResponse(
        res,
        400,
        "Final Handover sending failed. Please try again"
      );
  }
  return sendResponse(res, 200, "Final Handover sent to email successfully");
};

export const fillForm = async (req, res) => {
  const { id, fromEmail = false } = req.body;
  req.body.from_email = fromEmail === true ? 1 : 0;
  const [dataFetch] = await db.query(
    `SELECT * FROM final_handover_responses WHERE id = ${id}`
  );
  console.log(dataFetch);
  // console.log(chalk.red(JSON.stringify(dataFetch[0])));

  let form = req.body;

  console.log(chalk.red(JSON.stringify(form)));

  delete req.body.contractor;
  delete req.body.project;
  if (dataFetch[0]?.status === "Response Received") {
    return sendResponse(res, 400, "Response already submitted");
  }
  // console.log(req.files);

  let document = [];

  for (let i = 0; i <= 10; i++) {
    if (
      (req?.files && req.files[`document[${i}]`]) ||
      req.body[`document[${i}]`]
    ) {
      const file = req.files[`document[${i}]`];
      if (typeof file != "string" && typeof file == "object") {
        const filePath = await uploadFile("final_handover", file);
        document.push({ file: filePath, doc_no: i });
      } else {
        document.push({ file: req.body[`document[${i}]`], doc_no: i });
      }
    }
  }

  await deleteRecord(
    FinalHandoverResponseDocs,
    id,
    "final_handover_response_id"
  );

  req.body.images = document;

  req.body = await encodeAndStringifyFields(req.body);
  form.status = "Response Received";
  const { query, values } = updateQueryBuilder(FinalHandoverResponses, form);
  const [result] = await db.query(query, values);

  for (let doc of document) {
    const { query, values } = createQueryBuilder(FinalHandoverResponseDocs, {
      ...doc,
      final_handover_response_id: id ? id : result.insertId,
    });
    await db.query(query, values);
  }

  if (result.affectedRows > 0) {
    // also update status to Response Received if number of response equal to total response
    const [contractorFinalHandover] = await db.query(
      `SELECT * FROM final_handover WHERE id = ${dataFetch[0].final_handover_id}`
    );
    let status = "";
    if (
      contractorFinalHandover[0].total ===
      contractorFinalHandover[0].responses + 1
    ) {
      status = `, status = 'Response Received'`;
    }
    await db.query(
      `UPDATE final_handover SET responses = responses + 1 ${status}  WHERE id = ${dataFetch[0].final_handover_id}`
    );
    return sendResponse(res, 200, "Form Filled successfully");
  }
  return sendResponse(res, 400, "Record Not updated");
};

export const enableDisableForm = async (req, res) => {
  const { id, status } = req.body;
  const [update] = await db.query(
    `UPDATE final_handover SET status = ?  WHERE id = ?`,
    [status, id]
  );
  if (update.affectedRows > 0) {
    return sendResponse(res, 200, "Status updated successfully");
  }
  return sendResponse(
    res,
    400,
    "Some error occurred while updating the status "
  );
};
