                                 //! Not in us






import db from "../db-config.js";
import {
  insertActivityLog,
  getOrganizationAccordingToDepartment,
  whereCondition,
  makeJoins,
  countQueryCondition,
  deleteRecord,
  updateQueryBuilder,
  createQueryBuilder,
  searchConditionRecord,
  decodeAndParseFields,
} from "../helper/general.js";
import { sendResponse } from "../helper/wrapper.js";
import FirstAidBox from "../sequelize/FirstAidBoxSchema.js";
import {
  createUpdateActionFunction,
  getCustomActionFunction,
} from "./customActionCreationController.js";

/**Function to create/update First Aid Box   */
export const FirstAidBoxCreateUpdate = async (req, res) => {
  // if (!id) {
  //   const result = await getFirstCreatedAndAllOrganizationIds();

  //   if (!result.firstOrgId) {
  //     return sendResponse(res, 404, "No organization found.");
  //   }
  //   const unique_id = await uniqueIdGenerator(
  //     result.firstOrgId,
  //     req.body?.department || null,
  //     "FirstAidBox",
  //     "first_aid_box",
  //     "unique_id",
  //     "unique_id"
  //   );
  //   req.body.unique_id = unique_id;
  //   req.body.organization =
  //     organization.length > 0 ? organization : result.organizationIds;
  // }
  // const encodedDescription = await encodeSingle_statement(description);
  // req.body.description = encodedDescription;
  // req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  // /**If id comes in body then it will update the query */
  // const [checkNameWithOrganization] = await getRecord(
  //   "first_aid_box",
  //   "name",
  //   name
  // );
  // if (checkNameWithOrganization) {
  //   if (id && checkNameWithOrganization.id != id) {
  //     return sendResponse(res, 400, "First Aid name already exist");
  //   } else if (!id) {
  //     return sendResponse(res, 400, "First Aid name already exist");
  //   }
  // }
  // if (id) {
  //   /**Check that this organization have that particular name or not*/
  //   if (organization.length === 0) {
  //     return sendResponse(
  //       res,
  //       400,
  //       "Please Select at least one business Structure"
  //     );
  //   }

  //   /**update query */
  //   const { query, values } = updateQueryBuilder(FirstAidBox, req.body);
  //   await db.query(query, values);
  //   /**Update record for activity log */
  //   await insertActivityLog(req.user.sessionid, "update", "FirstAidBox", id);
  //   return sendResponse(res, 200, "Record updated successfully");
  // } else {
  //   const { query, values } = createQueryBuilder(FirstAidBox, req.body);
  //   const result = await db.query(query, values);
  //   /**Insert record for activity log */
  //   await insertActivityLog(
  //     req.user.sessionid,
  //     "create",
  //     "FirstAidBox",
  //     result.insertId
  //   );
  //   return sendResponse(res, 200, "Record created successfully");
  // }

  req.body = (await decodeAndParseFields([req.body]))[0];

  const {
    id,
    organization,
    department,
    task_data,
    action_taken,
    sidebar_id = 303,
  } = req.body;

  /**Check record if organization is not coming then fetch organization according to department */
  let organizationId = organization;

  const data = {
    task_data,
    department,
    files: req.files,
    user: req.user,
    id: action_taken,
    organization: organizationId,
    sidebar_id,
  };

  if (
    id &&
    req.body?.task_data &&
    req.body?.task_data[0] &&
    req.body?.task_data[0]?.role
  ) {
    const { status, arr } = await createUpdateActionFunction(data, req);
    if (status) {
      const action_taken = arr[0].id;
      req.body.action_taken = action_taken;
    }
    req.body.scheduled_status = "Scheduled";
  }
  if (department) {
    const recordAccordingToOrganization =
      await getOrganizationAccordingToDepartment(department);
    organizationId = recordAccordingToOrganization[0].organization;
    req.body.organization = organizationId;
  }
  /**If id comes in body then it will update the query */
  if (id) {
    req.body.updated_by = req.user.sessionid;
    /**Update First Aid Box Query */

    const { query, values } = updateQueryBuilder(FirstAidBox, req.body);
    await db.query(query, values);
    /**Insert Activity  */
    await insertActivityLog(req.user.sessionid, "update", "FirstAidBox", id);
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    req.body.created_by = req.user.sessionid;
    /**Insert record for First Aid Box */
    const { query, values } = createQueryBuilder(FirstAidBox, req.body);
    const createFirstAidBox = await db.query(query, values);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "First Aid Box",
      createFirstAidBox.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  }
};

/**Function to view all and single First Aid Box */
export const viewFirstAidBox = async (req, res) => {
  const { id } = req.params;
  const condition = await whereCondition({
    table: "first_aid_box",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    grouped: req.query.grouped,
    user: req.user,
  });
  const searchTableName = [
    "CONCAT(users.name , ' ' , users.surname)",
    "organization.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = first_aid_box.created_by",
    },
    {
      type: "left",
      targetTable: "location",
      onCondition: "location.id = first_aid_box.location",
    },
    {
      type: "left",
      targetTable: "department",
      onCondition: "department.id = first_aid_box.department",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition: "organization.id = first_aid_box.organization",
    },
    {
      type: "left",
      targetTable: "first_aid_box_content",
      onCondition: "first_aid_box_content.id = first_aid_box.content_list",
    },
  ];

  const joinsRecord = await makeJoins(joins);

  /**Record of all First Aid Box */
  const FirstAidBoxQuery = `SELECT first_aid_box.*, location.name AS location_name, department.name AS department_name,  users.name AS created_by, 
  organization.name AS organization_name , first_aid_box_content.name AS content_list_name
      FROM first_aid_box 
      ${joinsRecord} where first_aid_box.deleted = 0  ${searchCondition} ${condition}`;
  let [FirstAidBox] = await db.query(FirstAidBoxQuery);

  for (let aidBox of FirstAidBox) {
    // action taken
    if (aidBox?.action_taken) {
      const data = {
        params: { id: aidBox?.action_taken },
        user: req.user,
        query: {},
      };
      const customActionData = await getCustomActionFunction(data);
      aidBox.task_data = customActionData;
    }
    aidBox.inspection_checklist =
      typeof aidBox.inspection_checklist === "string"
        ? JSON.parse(aidBox?.inspection_checklist || "[{ point: '' }]")
        : aidBox.inspection_checklist;
    aidBox.schedule = JSON.parse(aidBox?.schedule || "[]");
  }

  // FirstAidBox = FirstAidBox.map((item) => {
  //   return {
  //     ...item,
  //     inspection_checklist: JSON.parse(item?.inspection_checklist || "[]"),
  //     task_data: JSON.parse(item?.task_data || "[]"),
  //   };
  // });

  /**Count of all First Aid Box */
  const totalRecord = await countQueryCondition(FirstAidBoxQuery);
  return sendResponse(res, 200, FirstAidBox, totalRecord);
};

/**Function to delete a specific First Aid Box */
export const deleteFirstAidBox = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteRecord("first_aid_box", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    insertActivityLog(req.user.sessionid, "delete", "First Aid Box", id);
    return sendResponse(res, 200, "Record deleted successfully");
  }
};
