import db from "../db-config.js";
import {
  countQueryCondition,
  decodeSingle_statement,
  deleteSettingRecord,
  encodeSingle_statement,
  getFilterConditions,
  getFirstCreatedAndAllOrganizationIds,
  getListingData,
  getRecord,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  settingsUpdater,
  uniqueIdGenerator,
  whereCondition,
} from "../helper/general.js";
import HighestQualification from "../sequelize/HighestQualificationSchema.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  createQueryBuilder,
  updateQueryBuilder,
} from "../helper/queryBuilder.js";

/**Function to create new Highest Qualification for employee  */
export const createUpdateHighestQualification = async (req, res) => {
  let { id, name, description, organization } = req.body;
  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "HighestQualification",
      "highest_qualification",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization =
      organization.length > 0 ? organization : result.organizationIds;
  }
  const encodedDescription = await encodeSingle_statement(description);
  req.body.description = encodedDescription;
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  /**If id comes in body then it will update the query */
  const [checkNameWithOrganization] = await getRecord(
    "highest_qualification",
    "name",
    name
  );
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(res, 400, "Highest qualification name already exist");
    } else if (!id) {
      return sendResponse(res, 400, "Highest qualification name already exist");
    }
  }
  if (id) {
    /**update query */
    if (organization.length === 0) {
      return sendResponse(
        res,
        400,
        "Please Select at least one business Structure"
      );
    }
    const { query, values } = updateQueryBuilder(
      HighestQualification,
      req.body
    );
    await db.query(query, values);
    /**Update record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "update",
      "Highest Qualification",
      id
    );
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const { query, values } = createQueryBuilder(
      HighestQualification,
      req.body
    );
    const result = await db.query(query, values);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "Highest Qualification",
      result.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  }
  /**If id comes in body then it will update the query */
  // if (id) {
  //   if (organization.length === 0) {
  //     return sendResponse(
  //       res,
  //       200,
  //       "Please select at least one business structure"
  //     );
  //   }
  //   const result = await settingsUpdater(
  //     HighestQualification,
  //     organization,
  //     req.body,
  //     req.user
  //   );
  //   if (!result) {
  //     return sendResponse(res, 404, "No data found");
  //   }

  //   /**Insert record for activity log */
  //   await insertActivityLog(
  //     req.user.sessionid,
  //     "update",
  //     "Highest Qualification",
  //     `This user Update Highest Qualification which id is ${id}`
  //   );

  //   return sendResponse(res, 200, "Record updated successfully");
  // } else {
  //   /** Insert new record */
  //   const insertPromises = organization.map(async (element) => {
  //     // Check if the category type already exists for the organization
  //     const [checkNameWithOrganization] = await db.query(
  //       `SELECT name FROM highest_qualification WHERE name = ? AND deleted = "0" AND organization = ?`,
  //       [name, element]
  //     );

  //     // If record not found for that name with particular organization, insert the record
  //     if (checkNameWithOrganization.length === 0) {

  //         const unique_id = await uniqueIdGenerator(
  //           element,
  //           req.body?.department || null,
  //           "HighestQualification",
  //           "highest_qualification",
  //           "unique_id",
  //           "unique_id"
  //         );

  //       // Insert Highest Qualification details
  //       const insertHighestQualificationQuery = `INSERT INTO highest_qualification(name, description, created_by, organization, unique_id) VALUES (?, ?, ?, ?, ?)`;
  //       await db.query(insertHighestQualificationQuery, [
  //         name,
  //         encodedDescription,
  //         req.user.sessionid,
  //         element,
  //         unique_id
  //       ]);

  //       // Insert record for activity log
  //       await insertActivityLog(
  //         req.user.sessionid,
  //         "create",
  //         "Highest Qualification",
  //         `This user created a new category '${name}' for this organization ${element}`
  //       );
  //     }
  //   });

  //   await Promise.all(insertPromises);

  //   return sendResponse(res, 200, "Record created successfully");
  // }
};

/**Function to view all and single HighestQualification */
export const viewHighestQualification = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "highest_qualification"
  );
  /** If value come with any search condition then search that word */
  const searchTableName = [
    "highest_qualification.name",
    "highest_qualification.description",
    "createdUser.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );
  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = highest_qualification.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);
  /**Record of all Skill */
  let highestQualificationQuery = `SELECT 
  highest_qualification.*, 
  highest_qualification.organization AS organizations, 
  createdUser.name AS created_by, 
  createdUser.surname AS created_by_surname, 
  createdUser.id AS created_by_id, 
  createdUser.profile AS created_by_profile
FROM highest_qualification
${joinsRecord} 
WHERE highest_qualification.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  // console.log(skillQuery, "skillQuery");
  let [highestQualification] = await db.query(highestQualificationQuery);
  highestQualification = await getListingData(highestQualification);
  /**Count all organization */
  const totalRecord = await countQueryCondition(highestQualificationQuery);
  return sendResponse(res, 200, highestQualification, totalRecord);

  // const { id } = req.params;

  // const condition = await whereCondition({
  //   table: "highest_qualification",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  // const searchTableName = [
  //   "highest_qualification.name",
  //   "highest_qualification.description",
  //   "CONCAT(users.name , ' ' , users.surname)",
  //   "organization.name",
  // ];
  // /** If value come with any search condition then search that word */
  // let searchCondition = await searchConditionRecord(
  //   req.query.search,
  //   searchTableName
  // );

  // /**Make Joins according to tables */
  // const joins = [
  //   {
  //     type: "left",
  //     targetTable: "users",
  //     onCondition: "users.id = highest_qualification.created_by",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "organization",
  //     onCondition: "organization.id = highest_qualification.organization",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "department",
  //     onCondition: "department.id = highest_qualification.department",
  //   },
  // ];
  // const joinsRecord = await makeJoins(joins);

  // const HighestQualificationQuery = `SELECT highest_qualification.*,users.id AS created_by_id, users.name AS created_by, organization.name AS organization_name , users.surname as created_by_surname , users.profile as created_by_profile , department.name as department_name FROM highest_qualification ${joinsRecord} where highest_qualification.deleted = 0 ${searchCondition} ${condition}`;
  // // return console.log(
  // //   HighestQualificationQuery,
  // //   "HighestQualificationQuery"
  // // );
  // let [HighestQualificationRecord] = await db.query(HighestQualificationQuery);

  // for (const item of HighestQualificationRecord) {
  //   item.description = await decodeSingle_statement(item.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM highest_qualification WHERE deleted = 0 AND name = ?`,
  //       [item.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     item.organizations = arr;
  //   }
  // }

  // /**Count all organization */
  // const totalRecord = await countQueryCondition(HighestQualificationQuery);

  // return sendResponse(res, 200, HighestQualificationRecord, totalRecord);
};

/**Function to delete a specific Highest Qualification */
export const deleteHighestQualification = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteSettingRecord(
    "highest_qualification",
    id
  );
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "delete",
      "HighestQualification",
      id
    );
    return sendResponse(res, 200, "Record deleted successfully");
  }
};
