import db from "../db-config.js";
import {
  countQueryCondition,
  createQueryBuilder,
  decodeAndParseFields,
  deleteRecord,
  encodeAndStringifyFields,
  insertActivityLog,
  updateQueryBuilder,
  whereCondition,
} from "../helper/general.js";
import { sendResponse } from "../helper/wrapper.js";
import InsuranceClaimLogs from "../sequelize/InsuranceClaimLogsSchema.js";

export const createUpdateInsuranceClaimLogs = async (req, res) => {
  const { id, insurance_claim_approval_status } = req.body;

  let state = id ? "updated" : "created";
  req.body.status = insurance_claim_approval_status;

  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;

  if (insurance_claim_approval_status == "Approved") {
    console.log("Approved", req.body);
    await db.query(
      `UPDATE insurance_claim SET insurance_claim_approval_status = "Approved" , insurance_approved_amount = ${req.body.insurance_approved_amount} , insurance_approval_date = "${req.body.insurance_approval_date}" WHERE id = ${req.body.insurance_claim_id}`
    );
  } else if (insurance_claim_approval_status == "Declined") {
    console.log("Declined", req.body);
    await db.query(
      `UPDATE insurance_claim SET insurance_claim_approval_status = "Declined", reason = "${req.body.reason}" , appeal = "${req.body.appeal}" , responsible_person = "${req.body.responsible_person}" WHERE id = ${req.body.insurance_claim_id}`
    );
  }
  req.body = await encodeAndStringifyFields(req.body);

  const { query, values } = id
    ? updateQueryBuilder(InsuranceClaimLogs, req.body)
    : createQueryBuilder(InsuranceClaimLogs, req.body);

  const [result] = await db.query(query, values);

  await insertActivityLog(
    req.user.sessionid,
    state,
    "Insurance Claim Logs",
    id ? id : result.insertId
  );
  return sendResponse(res, 200, `Record ${state} successfully`);
};

export const getInsuranceClaimLogs = async (req, res) => {
  const { id } = req.params;
  const condition = await whereCondition({
    table: "insurance_claim_logs",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    user: req.user,
    columnName: "insurance_claim_id",
  });

  const insuranceClaimQuery = `SELECT * FROM insurance_claim_logs WHERE deleted = 0 ${condition}`;

  let [results] = await db.query(insuranceClaimQuery);
  for (const result of results) {
    // const created_at = JSON.stringify();
    const { date, time } = formatDateTime(result.created_at);
    result.date = date;
    result.time = time;
  }
  results = await decodeAndParseFields(results);

  const totalRecord = await countQueryCondition(insuranceClaimQuery);

  return sendResponse(res, 200, results, totalRecord);
};

const formatDateTime = (isoString) => {
  const dateObj = new Date(isoString);

  // Extract the date part (YYYY-MM-DD)
  const date = dateObj.toISOString().split("T")[0];

  // Extract time part (hours:minutes:seconds)
  const time = dateObj.toTimeString().split(" ")[0]; // 'HH:MM:SS'

  return { date, time };
};

export const deleteInsuranceClaimLogs = async (req, res) => {
  const { id } = req.params;
  const deleteForm = await deleteRecord(InsuranceClaimLogs, id);
  if (deleteForm) {
    await insertActivityLog(
      req.user.sessionid,
      "delete",
      "Insurance Claim Logs",
      `This user deleted a new Insurance Claim Logs Record for organization ${id}`
    );
    return sendResponse(res, 200, "Record deleted successfully");
  }
  return sendResponse(res, 400, "Cannot delete record");
};

// insurance_approved_amount
// insurance_approval_date
// reason
// appeal
// responsible_person
