import asyncHandler from "express-async-handler";
import db from "../db-config.js";
import {
  decodeSingle_statement,
  encodeSingle_statement,
  insertActivityLog,
  makeJoins,
  storeError,
  settingsUpdater,
  deleteSettingRecord,
  whereCondition,
  createQueryBuilder,
  searchConditionRecord,
  countQueryCondition,
  uniqueIdGenerator,
  getFirstCreatedAndAllOrganizationIds,
  encodeAndStringifyFields,
  updateQueryBuilder,
  getFilterConditions,
  getListingData,
} from "../helper/general.js";
import MeasurementMetric from "../sequelize/MeasurementMetricSchema.js";
import { sendResponse } from "../helper/wrapper.js";

/**Function to create and update Measurement Metric  */
export const createUpdatedMeasurementMetric = async (req, res) => {
  const { id, organization } = req.body;

  if (id && organization.length === 0) {
    return sendResponse(res, 404, "Please Select at least one business Structure");
  }

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "MeasurementMetric",
      "measurement_metric",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization = organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id
    ? updateQueryBuilder(MeasurementMetric, req.body)
    : createQueryBuilder(MeasurementMetric, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(req.user.sessionid, status, "MeasurementMetric", id ? id : result.insertId);
  return sendResponse(res, 200, `Record ${status} Successfully`);
};
// export const createUpdatedMeasurementMetric = async (req, res) => {
//   const { id, name, description, organization } = req.body;
//   const encodedDescription = await encodeSingle_statement(description);
//   req.body.description = encodedDescription;

//   /**If id comes in body then it will update the query */
//   if (id) {
//     req.body.updated_by = req.user.sessionid;
//     if (organization.length === 0) {
//       return sendResponse(
//         res,
//         400,
//         "Please select at least one business structure"
//       );
//     }
//     const result = await settingsUpdater(
//       MeasurementMetric,
//       organization,
//       req.body,
//       req.user
//     );
//     if (!result) {
//       return sendResponse(res, 404, "No data found");
//     }
//     /**Insert record for activity log */
//     await insertActivityLog(
//       req.user.sessionid,
//       "update",
//       "Measurement Metric",
//       `This user Update other Skills which id is ${id}`
//     );

//     return sendResponse(res, 200, "Record updated successfully");
//   } else {
//     const insertPromises = organization.map(async (element) => {
//       /** Check if this organization already has the particular name */
//       const [checkNameWithOrganization] = await db.query(
//         `SELECT name FROM measurement_metric WHERE name = ? AND deleted = '0' AND organization = ?`,
//         [name, element]
//       );

//       /** If record not found for that name with particular organization, insert the record */
//       if (checkNameWithOrganization.length === 0) {
//         const unique_id = await uniqueIdGenerator(
//           element,
//           req?.body?.department || null,
//           "MeasurementMetric",
//           "measurement_metric",
//           "unique_id",
//           "unique_id"
//         );
//         req.body.unique_id = unique_id;

//         /** Insert Measurement Metric details */
//         req.body.created_by = req.user.sessionid;
//         req.body.organization = element;
//         const { query, values } = createQueryBuilder(MeasurementMetric, {
//           ...req.body,
//           organization: element,
//         });
//         await db.query(query, values);

//         /** Insert record for activity log */
//         await insertActivityLog(
//           req.user.sessionid,
//           "create",
//           "Measurement Metric",
//           `This user created a new other Skills named ${name} for organization ${element}`
//         );
//       }
//     });

//     await Promise.all(insertPromises);

//     return sendResponse(res, 200, "Record created successfully");
//   }
// };

/**Function to view all Measurement Metric */
export const viewAllMeasurementMetric = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(req, db, "measurement_metric");

  // const { id } = req.params;
  // const condition = await whereCondition({
  //   table: "measurement_metric",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   grouped: req.query.grouped,
  //   user: req.user,
  // });

  const searchTableName = [
    "measurement_metric.name",
    "measurement_metric.description",
    "CONCAT(createdUser.name, ' ', createdUser.surname)",
  ];

  /** If value comes with any search condition then search that word */
  let searchCondition = await searchConditionRecord(req.query.search, searchTableName);

  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = measurement_metric.created_by",
    },
    // {
    //   type: "left",
    //   targetTable: "organization",
    //   onCondition: "organization.id = measurement_metric.organization",
    // },
  ];
  const joinsRecord = await makeJoins(joins);

  /**Record of all alert */
  const measurement_metricDataFetchQuery = `SELECT measurement_metric.* , createdUser.name as created_by , createdUser.surname as created_by_surname , createdUser.id as created_by_id , measurement_metric.organization as organizations , createdUser.profile as created_by_profile
    FROM measurement_metric  
  ${joinsRecord}
    where measurement_metric.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  let [measurement_metricDataFetch] = await db.query(measurement_metricDataFetchQuery);
  measurement_metricDataFetch = await getListingData(measurement_metricDataFetch);

  // for (const measurement of measurement_metricDataFetch) {
  //   measurement.description = await decodeSingle_statement(measurement.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM measurement_metric WHERE deleted = 0 AND name = ?`,
  //       [measurement.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     measurement.organizations = arr;
  //   }
  // }
  const totalData = await countQueryCondition(measurement_metricDataFetchQuery);
  return sendResponse(res, 200, measurement_metricDataFetch, totalData);
};

/**Function to delete a specific Measurement Metric */
export const deleteMeasurementMetric = async (req, res) => {
  const { id } = req.params;

  /**Delete record of Measurement Metric*/
  await deleteSettingRecord("measurement_metric", id);

  await insertActivityLog(
    req.user.sessionid,
    "delete",
    "Measurement Metric",
    `This user deleted Measurement Metric  which id is ${id}`
  );

  return sendResponse(res, 200, "Record Deleted Successfully");
};
