import asyncHandler from "express-async-handler";
import path from "path";
import { fileURLToPath } from "url";
import db from "../db-config.js";
import organizationStructureSchema from "../sequelize/OrganizationSchema.js";
import {
  FetchedResultDecodeData,
  catchErrorResponse,
  countQueryCondition,
  createQueryBuilder,
  createStaticDataSettings,
  decodeSingle_statement,
  deleteRecord,
  encodeData,
  getParentLevel,
  getRecord,
  insertNotification,
  makeJoins,
  makeNameQuery,
  searchConditionRecord,
  sendErrorResponse,
  sendSuccessResponse,
  setSuperAdminPermission,
  uniqueIdGenerator,
  uniqueIdGeneratorForOrganization,
  updateQueryBuilder,
  uploadFile,
  validateParentId,
  whereCondition,
} from "../helper/general.js";
import { createRootDirectories } from "../seeders/ddrmSeeder.js";
import IncidentCategory from "../sequelize/IncidentCategorySchema.js";
import EngagementMethod from "../sequelize/EngagementMethodSchema.js";
import IncidentLocation from "../sequelize/IncidentLocationSchema.js";
import IncidentPpe from "../sequelize/IncidentPpeSchema.js";
import IllnessType from "../sequelize/IllnessTypeSchema.js";
import QualityIncidentType from "../sequelize/QualityIncidentTypeSchema.js";
import { sendResponse } from "../helper/wrapper.js";
import Category from "../sequelize/CategorySchema.js";
import PpeType from "../sequelize/PpeTypeSchema.js";
import Currency from "../sequelize/CurrencySchema.js";
import Location from "../sequelize/LocationSchema.js";
/**Function to create and update Organization*/
export const createUpdateOrganization = async (req, res) => {
  const imageObj = {
    business_logo: "business_logo",
    background_image: "background_image",
    header_image: "header_image",
    footer_image: "footer_image",
  };
  /** Check already exists  for the same name or not */
  let idCheck = req.body.id ? " AND id != " + req.body.id : "";
  const [organizationCheck] = await db.query(`
    SELECT * FROM organization WHERE name = '${req.body.name}' ${idCheck} `);

  if (organizationCheck.length > 0) {
    return sendResponse(res, 400, "Organization name already exists");
  }

  /**Check if that these fields is missing then show error that this field is missing */
  /**Check that if parent id and id is same while update then show error */
  if (req.body.id && req.body.parent_id == req.body.id) {
    return sendSuccessResponse(res, 400, `Parent and Child cannot be same`);
  }

  if (req.body.id && req.body.parent_id) {
    await validateParentId(req.body.id, req.body.parent_id, "organization");
  }

  let level =
    req.body.parent_id != 0 && req.body.parent_id != undefined
      ? (await getParentLevel(req.body.parent_id)) + 1
      : 1;
  req.body.level = level;

  /**Check that if description is coming then encode it */
  if (req.body.description)
    req.body.description = await encodeData(req.body.description);
  req.body.parent_id = req.body.parent_id ? req.body.parent_id : null;

  /**If Organization image is coming then upload */
  for (const key in imageObj) {
    if (req.files && req.files[imageObj[key]]) {
      let imagePath = await uploadFile(
        "organization",
        req.files[imageObj[key]]
      );
      let imageUrl = `${process.env.HARMONY_BACKEND_URL}/${imagePath}`;
      req.body[key] = imageUrl;
    }
  }

  const status = req.body.id ? "Updated" : "Created";
  req.body[req.body.id ? "updated_by" : "created_by"] = req.user.sessionid;

  if (!req.body.id) {
    const unique_id = await uniqueIdGeneratorForOrganization(
      req.body?.name,
      "ORG",
      "organization",
      "id"
    );
    req.body.unique_id = unique_id;
  }

  const { query, values } = req.body.id
    ? updateQueryBuilder(organizationStructureSchema, req.body)
    : createQueryBuilder(organizationStructureSchema, req.body);
  const [result] = await db.query(query, values);

  if (!req.body?.id) {
    await createRootDirectories();
    await setSuperAdminPermission();
    await createStaticDataSettings(IncidentCategory, result.insertId);
    await createStaticDataSettings(Category, result.insertId);
    await createStaticDataSettings(Currency, result.insertId);
    await createStaticDataSettings(Location, result.insertId);
    await createStaticDataSettings(PpeType, result.insertId);
    await createStaticDataSettings(EngagementMethod, result.insertId);
    await createStaticDataSettings(IncidentLocation, result.insertId, [
      "name",
      "description",
      "parent",
      "is_static",
      "created_by",
    ]);
    await createStaticDataSettings(IncidentPpe, result.insertId, [
      "name",
      "description",
      "parent",
      "created_by",
    ]);
    await createStaticDataSettings(IllnessType, result.insertId, [
      "name",
      "description",
      "parent",
      "created_by",
      "specify",
    ]);
    await createStaticDataSettings(QualityIncidentType, result.insertId);
  }

  await insertNotification(
    `Business Structure ${status}`,
    `User ${req.user.sessionid} ${status} a new business structure named ${req.body.name} `,
    req.user.sessionid,
    "text",
    req.user.sessionid
  );
  return sendSuccessResponse(res, 200, `Record ${status} successfully`);
};

/**Function to get Organization */
export const getUsersOrganization = async (req, res) => {
  const request = {
    table: "organization",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id: req.params.id,
    user: req.user,
  };
  const condition = await whereCondition(request);

  /** If value come with any search condition then search that word */
  const searchTableName = [
    "organization.name",
    "organization.description",
    "createdUser.name",
  ];
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  /**Make Joins according to tables */
  const nameDetailsArray = [
    {
      table: "createdUser",
      name: "created_by",
      fields: ["name", "profile", "surname"],
    },
  ];
  const nameDetailsQuery = await makeNameQuery(nameDetailsArray);

  /**Make joins record query */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = organization.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);

  /**Record of all plugin users */
  const organizationDataFetchQuery = `SELECT ${nameDetailsQuery},organization.* , createdUser.id as created_by_id , createdUser.name as created_by , createdUser.profile as created_by_profile , createdUser.surname as created_by_surname FROM organization ${joinsRecord} where organization.deleted = 0 ${searchCondition} ${condition}`;
  // console.log(organizationDataFetchQuery);
  const [organizationDataFetch] = await db.query(organizationDataFetchQuery);
  // return console.log(organizationDataFetch);
  // await FetchedResultDecodeData(
  //   organizationDataFetch,
  //   "description",
  //   "description"
  // );
  for (const organizationRecord of organizationDataFetch) {
    organizationRecord.description = await decodeSingle_statement(
      organizationRecord.description
    );
    const organizationId = organizationRecord.id;
    const DepartmentNameQuery = `SELECT id,name , parent_department FROM department WHERE deleted = 0 And organization = ${organizationId}`;
    const [DepartmentNameResult] = await db.query(DepartmentNameQuery);
    organizationRecord.department =
      DepartmentNameResult.length > 0 ? DepartmentNameResult : [];
  }

  const totalRecord = await countQueryCondition(organizationDataFetchQuery);
  return res.status(200).json({
    status: true,
    data: organizationDataFetch,
    total: totalRecord,
  });
};

/**Function to delete Organization record */
export const deleteOrganization = async (req, res) => {
  console.log(req.params.id);
  const deleteData = await deleteRecord(
    "organization",
    req.params.id,
    "id",
    req.user.sessionid
  );
  if (deleteData.status == false) {
    return sendErrorResponse(
      res,
      404,
      "This organization is using somewhere so it can't be deleted."
    );
  } else {
    await setSuperAdminPermission();
    return sendSuccessResponse(res, 200, `Record deleted successfully`);
  }
};
