import db from "../db-config.js";
  import { sendResponse } from "../helper/wrapper.js";
  import { 
    insertActivityLog, 
    searchConditionRecord, 
    makeJoins, 
    whereCondition, 
    countQueryCondition, 
    settingsUpdater,
    deleteSettingRecord, 
    encodeSingle_statement, 
    decodeSingle_statement, 
    uniqueIdGenerator,
    getFirstCreatedAndAllOrganizationIds,
    getRecord,
    getFilterConditions,
    getListingData,
  } from "../helper/general.js";
  import ReasonForInactive from "../sequelize/ReasonForInactiveSchema.js";
import { createQueryBuilder, updateQueryBuilder } from "../helper/queryBuilder.js";

  /** Function to create or update ReasonForInactive */
  export const createUpdateReasonForInactive = async (req, res) => {
    const { id, name, description,organization } = req.body;
    if (!id) {
      const result = await getFirstCreatedAndAllOrganizationIds();
  
      if (!result.firstOrgId) {
        return sendResponse(res, 404, "No organization found.");
      }
      const unique_id = await uniqueIdGenerator(
        result.firstOrgId,
        req.body?.department || null,
        "ReasonForInactive",
        "reason_for_inactive",
        "unique_id",
        "unique_id"
      );
      req.body.unique_id = unique_id;
      req.body.organization =
        organization.length > 0 ? organization : result.organizationIds;
    }
    const encodedDescription = await encodeSingle_statement(description);
    req.body.description = encodedDescription;
    req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
    /**If id comes in body then it will update the query */
    const [checkNameWithOrganization] = await getRecord("reason_for_inactive", "name", name);
    if (checkNameWithOrganization) {
      if (id && checkNameWithOrganization.id != id) {
        return sendResponse(res, 400, "Reason for Inactive name already exist");
      } else if (!id) {
        return sendResponse(res, 400, "Reason for Inactive name already exist");
      }
    }
    if (id) {
      /**Check that this organization have that particular name or not*/
      if (organization.length === 0) {
        return sendResponse(
          res,
          400,
          "Please Select at least one business Structure"
        );
      }
  
      /**update query */
      const { query, values } = updateQueryBuilder(ReasonForInactive, req.body);
      await db.query(query, values);
      /**Update record for activity log */
      await insertActivityLog(req.user.sessionid, "update", "ReasonForInactive", id);
      return sendResponse(res, 200, "Record updated successfully");
    } else {
      const { query, values } = createQueryBuilder(ReasonForInactive, req.body);
      const result = await db.query(query, values);
      /**Insert record for activity log */
      await insertActivityLog(
        req.user.sessionid,
        "create",
        "ReasonForInactive",
        result.insertId
      );
      return sendResponse(res, 200, "Record created successfully");
    }
  };

  /** Function to view all or single ReasonForInactive */
  export const viewReasonForInactive = async (req, res) => {
  
    let { organizationCondition, condition } = await getFilterConditions(
      req,
      db,
      "reason_for_inactive"
    );
    /** If value come with any search condition then search that word */
    const searchTableName = [
      "reason_for_inactive.name",
      "reason_for_inactive.description",
      "createdUser.name",
    ];
    /** If value come with any search condition then search that word */
    let searchCondition = await searchConditionRecord(
      req.query.search,
      searchTableName
    );
    /**Make Joins according to tables */
    const joins = [
      {
        type: "left",
        targetTable: "users as createdUser",
        onCondition: "createdUser.id = reason_for_inactive.created_by",
      },
    ];
    const joinsRecord = await makeJoins(joins);
    /**Record of all reasonForInactive */
    let reasonForInactiveQuery = `SELECT 
    reason_for_inactive.*, 
    reason_for_inactive.organization AS organizations, 
    createdUser.name AS created_by, 
    createdUser.surname AS created_by_surname, 
    createdUser.id AS created_by_id, 
    createdUser.profile AS created_by_profile
  FROM reason_for_inactive
  ${joinsRecord} 
  WHERE reason_for_inactive.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;
  
    // console.log(skillQuery, "skillQuery");
    let [reasonForInactive] = await db.query(reasonForInactiveQuery);
    reasonForInactive = await getListingData(reasonForInactive);
    /**Count all organization */
    const totalRecord = await countQueryCondition(reasonForInactiveQuery);
    return sendResponse(res, 200, reasonForInactive, totalRecord);
  















    // const { id } = req.params;
    // const condition = await whereCondition({
    //   table: "reason_for_inactive",
    //   page: req.query.page,
    //   all: req.query.all,
    //   pageSize: req.query.pageSize,
    //   filter: req.query.filter,
    //   id,
    //   user: req.user,
    //   grouped: req.query.grouped,
    // });

    // const searchFields = [
    //   "reason_for_inactive.name",
    //   "reason_for_inactive.description",
    //   "users.name",
    //   "organization.name"
    // ];
    // let searchCondition = await searchConditionRecord(req.query.search, searchFields);
    // const joins = [
    //   { type: "left", targetTable: "users", onCondition: "users.id = reason_for_inactive.created_by" },
    //   { type: "left", targetTable: "organization", onCondition: "organization.id = reason_for_inactive.organization" }
    // ];
    // const joinsRecord = await makeJoins(joins);

    // const fetchQuery = `SELECT reason_for_inactive.*, users.name AS created_by, users.surname as created_by_surname, organization.name AS organization_name FROM reason_for_inactive ${joinsRecord} WHERE reason_for_inactive.deleted = 0 ${searchCondition} ${condition}`;
    // let [records] = await db.query(fetchQuery);

    // for (const record of records) {
    //   record.description = await decodeSingle_statement(record.description);
    //    if (req.query.grouped == "true") {
    //     const [organizations] = await db.query(
    //       `SELECT organization FROM reason_for_inactive WHERE deleted = 0 AND name = ?`,
    //       [record.name]
    //     );
    //     const arr = organizations.map((item) => item.organization);
    //     record.organizations = arr;
    //   }
    // }

    // const totalRecord = await countQueryCondition(fetchQuery);
    // return sendResponse(res, 200, records, totalRecord);
  };

  /** Function to delete ReasonForInactive */
  export const deleteReasonForInactive = async (req, res) => {
    const { id } = req.params;
    const deleteRecord = await deleteSettingRecord("reason_for_inactive", id);
    if (deleteRecord) {
      await insertActivityLog(req.user.sessionid, "delete", "ReasonForInactive", id);
      return sendResponse(res, 200, "Record deleted successfully");
    } else {
      return sendResponse(res, 404, "Record not found");
    }
  };