import db from "../db-config.js";
import { countQueryCondition, whereCondition } from "../helper/general.js";
import { sendResponse } from "../helper/wrapper.js";
import RegulatoryBody  from "../sequelize/RegulatoryBodySchema.js"; // for sync purpose only not to be removed
export async function getRegulatoryBody(req, res) {
  const groupBy = req.query?.groupBy || "name";

  const filterObj = JSON.parse(req.query?.filter || "{}");
  const name = filterObj?.name || "";
  const government_sphere = filterObj?.government_sphere || "";
  const sector = filterObj?.sector || "";

  const nameFilter = name ? ` AND regulatory_body.name LIKE '%${name}%'` : "";
  const governmentSphereFilter = government_sphere
    ? ` AND regulatory_body.government_sphere LIKE '%${government_sphere}%'`
    : "";
  const sectorFilter = sector
    ? ` AND regulatory_body.sector LIKE '%${sector}%'`
    : "";
  const fetchQuery = `SELECT MAX( regulatory_body.${groupBy} ) AS ${groupBy} FROM regulatory_body WHERE  regulatory_body.deleted = 0 ${nameFilter} ${governmentSphereFilter} ${sectorFilter} GROUP BY ${groupBy} `;
  const [regulatoryBodies] = await db.query(fetchQuery);
  return sendResponse(res, 200, regulatoryBodies);
}
