import xlsx from "xlsx";
import fs from "fs";
import path from "path";
import db from "../db-config.js";

function readExcelFile(filePath) {
  try {
    const workbook = xlsx.readFile(filePath);
    let sheetData = {};

    workbook.SheetNames.forEach((sheetName) => {
      const worksheet = workbook.Sheets[sheetName];
      console.log("worksheet: ", worksheet);
      sheetData[sheetName] = xlsx.utils.sheet_to_json(worksheet);
    });

    // console.log("sheetData: ", sheetData["Location Name List"]);
    // const RegulatoryBodyData = getSheetData(sheetData, " Bodies");
  } catch (error) {
    console.error("Error reading Excel file:", error);
    throw error;
  }
}
const fileName = "Area_List.xlsx";
const filePath = path.join(process.cwd(), "public", fileName);
// readExcelFile(filePath);
function getSheetData(sheetData, sheetName) {
  try {
    if (!sheetData[sheetName]) {
      throw new Error(`Sheet ${sheetName} not found in the Excel file.`);
    }
    return sheetData[sheetName];
  } catch (error) {
    console.error(error.message);
  }
}

const bulkInsert = async (tableName, data, columns) => {
  if (!data || data.length === 0) {
    console.warn(`No data to insert into ${tableName}`);
    return;
  }

  // Prepare placeholders for bulk insert (e.g. (?, ?), (?, ?), ...)
  const placeholders = `(${columns.map(() => "?").join(", ")})`;
  console.log("placeholders: ", placeholders);

  const values = data.map((row) => [
    ...Object.values(row),
    1, // Static value `1` for `created_by`
  ]);
  console.log("values: ", values);

  const query = `
  INSERT INTO ${tableName} (${columns.join(", ")}) 
  VALUES ${values.map(() => placeholders).join(", ")}
  `;
  try {
    await db.query(query, values.flat());
    console.log(`Data successfully inserted into ${tableName}`);
  } catch (err) {
    console.error(`Error inserting data into ${tableName}:`, err);
  }
};

// async function insertData() {
//   try {
//     const fileName = "vehicle_auto_parts.xlsx";
//     const filePath = path.join(process.cwd(), "public", fileName);
//     if (!fs.existsSync(filePath)) {
//       console.error(`Error: File not found at path -> ${filePath}`);
//       process.exit(1);
//     }
//     const excelData = readExcelFile(filePath);
//     const sheet2 = getSheetData(excelData, "Sheet2");
//     const governmentInfoData = getSheetData(excelData, "Regulatory Bodies");
//     const columnNames = {
//       ProvinceHospital: ["province", "name", "created_by"],
//       GovernmentInfo: ["government_sphere", "name", "sector", "regulatory_body", "created_by"],
//     };
//     await bulkInsert("hospital", provinceHospitalData, columnNames.ProvinceHospital);
//     await bulkInsert("regulatory_body", governmentInfoData, columnNames.GovernmentInfo);
//   } catch (error) {
//     console.error(error.message);
//   }
// }

const insertData = async () => {
  const fileName = "Area_List.xlsx";
  const filePath = path.join(process.cwd(), "public", fileName);
  if (!fs.existsSync(filePath)) {
    console.error(`Error: File not found at path -> ${filePath}`);
    process.exit(1);
  }
  const excelData = readExcelFile(filePath);
  return console.log("excelData: ", excelData);
  const data = getSheetData(excelData, "Sheet2");
  const parentCategories = [
    "Exterior Body Parts",
    "Lighting Systems",
    "Windows and Glass",
    "Tires and Wheels",
    "Suspension and Steering",
    "Engine Components",
    "Drivetrain",
    "Braking System",
    "Exhaust System",
    "Electrical Components",
    "Airbags and Safety Systems",
    "Interior Parts",
    "Cooling and HVAC System",
    "Fuel System",
    "Miscellaneous Parts",
  ];

  let lastParentId = null; // Store the last inserted parent ID
  let isFirstParentInserted = false; // Flag to check if the first parent has been inserted

  for (const row of data) {
    const cellValue = Object.values(row)[0]?.trim(); // Get the first key from the row, which is the parent category

    if (!cellValue) {
      continue; // Skip empty rows
    }

    try {
      if (!isFirstParentInserted) {
        const [result] = await db.query("INSERT INTO vehicle_parts (name, parent_id) VALUES (?, ?)", [
          parentCategories[0],
          null,
        ]);
        lastParentId = result.insertId;
        isFirstParentInserted = true;
        console.log("isFirstParentInserted: ", isFirstParentInserted);
        console.log(`Inserted First Parent: ${parentCategories[0]}, ID: ${lastParentId}`);
      } else {
        if (parentCategories.includes(cellValue)) {
          console.log("cellValue: ", cellValue);
          // Insert parent from the list if detected after the first parent
          const [result] = await db.query(
            "INSERT INTO vehicle_parts (name, parent_id) VALUES (?, ?)",
            [cellValue, null] // Insert as new parent
          );
          lastParentId = result.insertId; // Update the last parent ID
          console.log(`Inserted Parent: ${cellValue}, ID: ${lastParentId}`);
        } else {
          // Insert child vehicle_parts with the lastParentId
          if (lastParentId !== null) {
            console.log("lastParentId: ", lastParentId);
            await db.query(
              "INSERT INTO vehicle_parts (name, parent_id) VALUES (?, ?)",
              [cellValue, lastParentId] // Child has parent_id of the last inserted parent
            );
            console.log(`Inserted Child: ${cellValue}, Parent ID: ${lastParentId}`);
          } else {
            console.warn(`Orphan Child Found: ${cellValue} (No Parent Defined)`);
          }
        }
      }
    } catch (err) {
      console.error("Error inserting data:", err);
    }
  }
};

// insertData();

// const getColumnData = (sheet) => {
//   const data = [];
//   const seenRows = new Set(); // To track unique row numbers

//   for (const cell in sheet) {
//     if (cell.startsWith("A") && sheet[cell].v) {
//       const row = parseInt(cell.slice(1), 10); // Extract row number

//       if (!seenRows.has(row)) {
//         // Check if row is already added
//         data.push({ row, value: sheet[cell].v });
//         seenRows.add(row); // Mark row as seen
//       }
//     }
//   }

//   return data.sort((a, b) => a.row - b.row); // Ensure rows are in order
// };

// Process hierarchy from column data
// const processHierarchy = (data) => {
//   let gp = 1;
//   let grandParentId = null;
//   let parentId = null;
//   const records = [];

//   for (let i = 0; i < data.length; i++) {
//     const current = data[i];
//     const next = data[i + 1] || { row: current.row + 2 };

//     const rowGap = next.row - current.row;

//     if (rowGap >= 3 || current.row === 1) {
//       // Grandparent
//       grandParentId = null;
//       parentId = null;
//       records.push({ name: current.value, parent_id: null });
//       grandParentId = gp; // Use array index as temporary ID
//     } else if (rowGap >= 2 || current.row === 3) {
//       // Parent
//       parentId = records.length + 1; // Temporary ID
//       records.push({ name: current.value, parent_id: grandParentId });
//     } else {
//       // Child
//       records.push({ name: current.value, parent_id: parentId });
//     }
//   }

//   return records;
// };

// import data from "../columnData.json" assert { type: "json" };
// // console.log("data: ", data);
// (async () => {
//   try {
//     // const fileName = "Area_List.xlsx";
//     // const filePath = path.join(process.cwd(), "public", fileName);
//     // if (!fs.existsSync(filePath)) {
//     //   console.error(`Error: File not found at path -> ${filePath}`);
//     //   process.exit(1);
//     // }
//     // const workbook = xlsx.readFile(filePath);
//     // const sheet = workbook.Sheets["Location Name List"]; // Specify the sheet name
//     // const columnData = getColumnData(sheet);
//     // fs.writeFileSync("columnData.json", JSON.stringify(columnData, null, 2));
//     // const records = processHierarchy(columnData);
//     // for (const record of records) {
//     //   await db.query("INSERT INTO new_location (name, parent_id) VALUES (?, ?)", [record.name, record.parent_id]);
//     // }
//     let grandParentId = null;
//     let parentId = null;
//     for (let i = 0; i < data.length; i++) {
//       const current = data[i];
//       const prev = data[i - 1];
//       const rowGap = current.row - prev?.row || 0;

//       if (rowGap >= 3 || current.row === 1) {
//         const [grandParent] = await db.query("INSERT INTO new_location (name, parent_id) VALUES (?, ?)", [
//           current.value,
//           null,
//         ]);
//         grandParentId = grandParent.insertId;
//         console.log("grandParentId: inserted", grandParentId);
//       } else if (rowGap === 2 || current.row === 3) {
//         const [parent] = await db.query("INSERT INTO new_location (name, parent_id) VALUES (?, ?)", [
//           current.value,
//           grandParentId,
//         ]);
//         parentId = parent.insertId;
//         console.log("parentId: inserted ", parentId);
//       } else if (rowGap === 1) {
//         const [child] = await db.query("INSERT INTO new_location (name, parent_id) VALUES (?, ?)", [
//           current.value,
//           parentId,
//         ]);
//         console.log("child: inserted ", child.insertId);
//       }
//     }
//     console.log("Data successfully inserted into new_location table");
//   } catch (err) {
//     console.error("Error:", err.message);
//   }
// })();
async function insertBodyParts(data, parentId = null) {
  for (const item of data) {
    // Insert the current item into the database
    const [result] = await db.execute(`INSERT INTO body_parts (name, parent_id) VALUES (?, ?)`, [item.name, parentId]);

    const insertedId = result.insertId;

    // If the item has children, recursively insert them
    if (item?.children && item?.children?.length > 0) {
      await insertBodyParts(item.children, insertedId);
    }
  }
}

// Example usage
