import jwt from "jsonwebtoken";
import { storeError } from "./general.js";
import db from "../db-config.js";

/**Verify token  */
export const verifyToken = (req, res, next) => {
  try {
    const authHeader = req.headers["authorization"];
    const token = authHeader && authHeader.split(" ")[1];
    if (token == null) {
      return res.status(401).json({
        status: false,
        message: "Token is required",
      });
    }
    jwt.verify(token, process.env.JWT_KEY, (err, decoded) => {
      if (err) {
        return res.status(403).json({
          status: false,
          message: "Your token is expired please log in again",
        });
      }
      req.user = decoded;
      next();
    });
  } catch (error) {
    return res.status(500).json({ status: false, message: error.message });
  }
};

export const publicUrlAccess = async (req, res, next) => {
  try {
    if (req.user && req.user.isSuperAdmin != 1) {
      const [policy] = await db.query(
        `SELECT policy_reviewer,policy_owner, policy_approver FROM policy WHERE deleted = 0 AND id = ${req.params.id}`
      );
      if (!policy[0]) {
        return res.status(404).json({
          status: false,
          message: "Policy not found",
        });
      }
      const team = JSON.parse(policy[0]?.policy_reviewer || `[]`);
      if (
        !team.includes(req.user.sessionid) &&
        policy[0]?.policy_owner !== req.user.sessionid &&
        policy[0]?.policy_approver !== req.user.sessionid
      ) {
        return res
          .status(403)
          .json({ status: false, message: "Access Denied" });
      }
    }
    next();
  } catch (error) {
    storeError(error);
    return res.status(500).json({
      status: false,
      message: error.message,
    });
  }
};
