import { sendResponse } from "../helper/wrapper.js";

export const ipMapper = new Map();
const LOGIN_LIMIT = 5;
const LOGIN_TIME = 5 * 60 * 1000;

const rateLimiter = (req, res, next) => {
  const ip = req.headers["x-forwarded-for"] || req.connection.remoteAddress;
  const currentTime = Date.now();

  const ipData = ipMapper.get(ip) || { requests: 0, time: currentTime };

  if (currentTime - ipData.time > LOGIN_TIME) {
    ipMapper.set(ip, { requests: 1, time: currentTime });
    next();
  } else {
    ipData.requests += 1;

    if (ipData.requests > LOGIN_LIMIT) {
      const remainingTime = LOGIN_TIME - (currentTime - ipData.time);
      const timeLeftMinutes = Math.floor(remainingTime / 1000 / 60);
      const timeLeftSeconds = Math.floor((remainingTime / 1000) % 60);

      return sendResponse(
        res,
        429,
        `Too many requests. Please try again in ${timeLeftMinutes} minutes and ${timeLeftSeconds} seconds.`
      );
    } else {
      ipMapper.set(ip, ipData);
      next();
    }
  }
};

export default rateLimiter;
