import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateCollectionSite, deleteCollectionSite, viewCollectionSite } from "../controller/collectionSiteController.js";

/**
 * @swagger
 * tags:
 *   name:  collection site
 *   description: API operations for managing  collection site
 */
const collectionSiteRoutes = Router();

/**
 * @swagger
 * /api/collectionSite/create-update-collection-site:
 *   post:
 *     summary: Create or update a  collection site
 *     tags: [ collection site]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
collectionSiteRoutes.post(
  "/create-update-collection-site",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 405 , "collection_site")(req, res, next);
  },
  controllerWrapper(createUpdateCollectionSite)
);

/**
 * @swagger
 * /api/collectionSite/get-collection-site:
 *   get:
 *     summary: Get all records of  collection site
 *     tags: [ collection site]
 */
collectionSiteRoutes.get(
  "/get-collection-site",
  verifyToken,
  sideBarPermissionCheck("view", 405, "collection_site"),
  controllerWrapper(viewCollectionSite)
);

/**
 * @swagger
 * /api/collectionSite/get-collection-site/{id}:
 *   get:
 *     summary: Get a specific record of  collection site
 *     tags: [ collection site]
 */
collectionSiteRoutes.get(
  "/get-collection-site/:id",
  verifyToken,
  sideBarPermissionCheck("view", 405, "collection_site"),
  controllerWrapper(viewCollectionSite)
);

/**
 * @swagger
 * /api/collectionSite/delete-collection-site/{id}:
 *   delete:
 *     summary: Delete a specific record of  collection site
 *     tags: [ collection site]
 */
collectionSiteRoutes.delete(
  "/delete-collection-site/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 405, "collection_site"),
  controllerWrapper(deleteCollectionSite)
);

export default collectionSiteRoutes;