import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateControlType, deleteControlType, viewControlType } from "../controller/controlTypeController.js";

/**
 * @swagger
 * tags:
 *   name:  control type
 *   description: API operations for managing  control type
 */
const controlTypeRoutes = Router();

/**
 * @swagger
 * /api/controlType/create-update-control-type:
 *   post:
 *     summary: Create or update a  control type
 *     tags: [ control type]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
controlTypeRoutes.post(
  "/create-update-control-type",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 405 , "control_type")(req, res, next);
  },
  controllerWrapper(createUpdateControlType)
);

/**
 * @swagger
 * /api/controlType/get-control-type:
 *   get:
 *     summary: Get all records of  control type
 *     tags: [ control type]
 */
controlTypeRoutes.get(
  "/get-control-type",
  verifyToken,
  sideBarPermissionCheck("view", 405, "control_type"),
  controllerWrapper(viewControlType)
);

/**
 * @swagger
 * /api/controlType/get-control-type/{id}:
 *   get:
 *     summary: Get a specific record of  control type
 *     tags: [ control type]
 */
controlTypeRoutes.get(
  "/get-control-type/:id",
  verifyToken,
  sideBarPermissionCheck("view", 405, "control_type"),
  controllerWrapper(viewControlType)
);

/**
 * @swagger
 * /api/controlType/delete-control-type/{id}:
 *   delete:
 *     summary: Delete a specific record of  control type
 *     tags: [ control type]
 */
controlTypeRoutes.delete(
  "/delete-control-type/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 405, "control_type"),
  controllerWrapper(deleteControlType)
);

export default controlTypeRoutes;