import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateFirstAidBoxContent, deleteFirstAidBoxContent, viewFirstAidBoxContent } from "../controller/firstAidBoxContentController.js";

/**
 * @swagger
 * tags:
 *   name: FirstAidBoxContent
 *   description: API operations for managing FirstAidBoxContent
 */
const firstAidBoxContentRoutes = Router();

/**
 * @swagger
 * /api/firstAidBoxContent/create-update-first-aid-box-content:
 *   post:
 *     summary: Create or update a FirstAidBoxContent
 *     tags: [FirstAidBoxContent]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
firstAidBoxContentRoutes.post(
  "/create-update-first-aid-box-content",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 364 , "first_aid_box_content")(req, res, next);
  },
  controllerWrapper(createUpdateFirstAidBoxContent)
);

/**
 * @swagger
 * /api/firstAidBoxContent/get-first-aid-box-content:
 *   get:
 *     summary: Get all records of FirstAidBoxContent
 *     tags: [FirstAidBoxContent]
 */
firstAidBoxContentRoutes.get(
  "/get-first-aid-box-content",
  verifyToken,
  sideBarPermissionCheck("view", 364, "first_aid_box_content"),
  controllerWrapper(viewFirstAidBoxContent)
);

/**
 * @swagger
 * /api/firstAidBoxContent/get-first-aid-box-content/{id}:
 *   get:
 *     summary: Get a specific record of FirstAidBoxContent
 *     tags: [FirstAidBoxContent]
 */
firstAidBoxContentRoutes.get(
  "/get-first-aid-box-content/:id",
  verifyToken,
  sideBarPermissionCheck("view", 364, "first_aid_box_content"),
  controllerWrapper(viewFirstAidBoxContent)
);

/**
 * @swagger
 * /api/firstAidBoxContent/delete-first-aid-box-content/{id}:
 *   delete:
 *     summary: Delete a specific record of FirstAidBoxContent
 *     tags: [FirstAidBoxContent]
 */
firstAidBoxContentRoutes.delete(
  "/delete-first-aid-box-content/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 364, "first_aid_box_content"),
  controllerWrapper(deleteFirstAidBoxContent)
);

export default firstAidBoxContentRoutes;