import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateLocation, deleteLocation,viewLocationDropDown, viewLocation,getParentLocationList } from "../controller/locationController.js";

/**
 * @swagger
 * tags:
 *   name: Location
 *   description: API operations for managing Location
 */
const locationRoutes = Router();

/**
 * @swagger
 * /api/location/create-update-location:
 *   post:
 *     summary: Create or update a Location
 *     tags: [Location]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
locationRoutes.post(
  "/create-update-location",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 368 , "location")(req, res, next);
  },
  controllerWrapper(createUpdateLocation)
);

/**
 * @swagger
 * /api/location/get-location:
 *   get:
 *     summary: Get all records of Location
 *     tags: [Location]
 */
locationRoutes.get(
  "/get-location",
  verifyToken,
  sideBarPermissionCheck("view", 368, "location"),
  controllerWrapper(viewLocation)
);

/**
 * @swagger
 * /api/location/get-location/{id}:
 *   get:
 *     summary: Get a specific record of Location
 *     tags: [Location]
 */
locationRoutes.get(
  "/get-location/:id",
  verifyToken,
  sideBarPermissionCheck("view", 368, "location"),
  controllerWrapper(viewLocation)
);

/**
 * @swagger
 * /api/location/delete-location/{id}:
 *   delete:
 *     summary: Delete a specific record of Location
 *     tags: [Location]
 */
locationRoutes.delete(
  "/delete-location/:id",
  verifyToken,
  controllerWrapper(deleteLocation)
);
/**
 * @swagger
 * /api/location/delete-location/{id}:
 *   get:
 *     summary: Get the list for selecting parent category
 *     tags: [Location]
 *     parameters:
 *       - in: query
 *         organization : [1,2,34,4]
 *         schema:
 *           type: Array
 *         description: Array of organization to fetch the list
 */


locationRoutes.get("/get-location-list", verifyToken, controllerWrapper(getParentLocationList));

/**
 * @swagger
 * /api/location/get-location-dropdown:
 *   get:
 *     summary: Get the list all Location
 *     tags:
 *       - Location
 *     description: The location
 *     responses:
 *       200:
 *         description: Location data
 *       404:
 *         description: Location not found
 *       500:
 *         description: Internal server error
 */

locationRoutes.get(
  "/get-location-dropdown",
  verifyToken,
  // sideBarPermissionCheck("view", 341, "disability"),
  controllerWrapper(viewLocationDropDown)
);
export default locationRoutes;