import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateOccupationalDisease, deleteOccupationalDisease, viewOccupationalDisease } from "../controller/occupationalDiseaseController.js";

/**
 * @swagger
 * tags:
 *   name:  occupational disease
 *   description: API operations for managing  occupational disease
 */
const occupationalDiseaseRoutes = Router();

/**
 * @swagger
 * /api/occupationalDisease/create-update-occupational-disease:
 *   post:
 *     summary: Create or update a  occupational disease
 *     tags: [ occupational disease]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" , occupational_disease_type: "occupational_disease_type_id" }
 */
occupationalDiseaseRoutes.post(
  "/create-update-occupational-disease",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 13 , "occupational_disease")(req, res, next);
  },
  controllerWrapper(createUpdateOccupationalDisease)
);

/**
 * @swagger
 * /api/occupationalDisease/get-occupational-disease:
 *   get:
 *     summary: Get all records of  occupational disease
 *     tags: [ occupational disease]
 */
occupationalDiseaseRoutes.get(
  "/get-occupational-disease",
  verifyToken,
  sideBarPermissionCheck("view", 13, "occupational_disease"),
  controllerWrapper(viewOccupationalDisease)
);

/**
 * @swagger
 * /api/occupationalDisease/get-occupational-disease/{id}:
 *   get:
 *     summary: Get a specific record of  occupational disease
 *     tags: [ occupational disease]
 */
occupationalDiseaseRoutes.get(
  "/get-occupational-disease/:id",
  verifyToken,
  sideBarPermissionCheck("view", 13, "occupational_disease"),
  controllerWrapper(viewOccupationalDisease)
);

/**
 * @swagger
 * /api/occupationalDisease/delete-occupational-disease/{id}:
 *   delete:
 *     summary: Delete a specific record of  occupational disease
 *     tags: [ occupational disease]
 */
occupationalDiseaseRoutes.delete(
  "/delete-occupational-disease/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 13, "occupational_disease"),
  controllerWrapper(deleteOccupationalDisease)
);

export default occupationalDiseaseRoutes;