import { RiskSender } from "../controller/opportunityManagementController.js";
import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";

/**
 * @swagger
 * tags:
 *   name: Opportunity Management
 *   description: API Operations For Managing Operational Risks
 */

const opportunityManagementRoutes = Router();

/**
 * @swagger
 * /opportunityManagement/risk-sender:
 *   post:
 *     summary: Sends risk information to create a meeting agenda or action item
 *     tags: [Opportunity Management]
 *     security:
 *       - bearerAuth: []
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             type: object
 *             properties:
 *               module_id:
 *                 type: integer
 *                 example: 1
 *               sub_module_id:
 *                 type: integer
 *                 example: 2
 *               id:
 *                 type: integer
 *                 example: 3
 *               type:
 *                 type: string
 *                 example: "meeting"
 *                 enum: ["meeting", "action"]
 *     responses:
 *       200:
 *         description: Success message for either meeting or action creation
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 message:
 *                   type: string
 *                   example: "Meeting Agenda Created Successfully"
 *       400:
 *         description: Invalid request type
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 message:
 *                   type: string
 *                   example: "type is not valid. Valid types are meeting or action"
 */

opportunityManagementRoutes.post(
  "/risk-sender",
  verifyToken,
  controllerWrapper(RiskSender)
);

export default opportunityManagementRoutes;
