import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateSeverity, deleteSeverity, viewSeverity } from "../controller/severityController.js";

/**
 * @swagger
 * tags:
 *   name:  severity
 *   description: API operations for managing  severity
 */
const severityRoutes = Router();

/**
 * @swagger
 * /api/severity/create-update-severity:
 *   post:
 *     summary: Create or update a  severity
 *     tags: [ severity]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
severityRoutes.post(
  "/create-update-severity",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 403 , "severity")(req, res, next);
  },
  controllerWrapper(createUpdateSeverity)
);

/**
 * @swagger
 * /api/severity/get-severity:
 *   get:
 *     summary: Get all records of  severity
 *     tags: [ severity]
 */
severityRoutes.get(
  "/get-severity",
  verifyToken,
  sideBarPermissionCheck("view", 403, "severity"),
  controllerWrapper(viewSeverity)
);

/**
 * @swagger
 * /api/severity/get-severity/{id}:
 *   get:
 *     summary: Get a specific record of  severity
 *     tags: [ severity]
 */
severityRoutes.get(
  "/get-severity/:id",
  verifyToken,
  sideBarPermissionCheck("view", 403, "severity"),
  controllerWrapper(viewSeverity)
);

/**
 * @swagger
 * /api/severity/delete-severity/{id}:
 *   delete:
 *     summary: Delete a specific record of  severity
 *     tags: [ severity]
 */
severityRoutes.delete(
  "/delete-severity/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 403, "severity"),
  controllerWrapper(deleteSeverity)
);

export default severityRoutes;