import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateWasteDisposalMethod, deleteWasteDisposalMethod, viewWasteDisposalMethod } from "../controller/wasteDisposalMethodController.js";

/**
 * @swagger
 * tags:
 *   name: WasteDisposalMethod
 *   description: API operations for managing WasteDisposalMethod
 */
const wasteDisposalMethodRoutes = Router();

/**
 * @swagger
 * /api/wasteDisposalMethod/create-update-waste-disposal-method:
 *   post:
 *     summary: Create or update a WasteDisposalMethod
 *     tags: [WasteDisposalMethod]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
wasteDisposalMethodRoutes.post(
  "/create-update-waste-disposal-method",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 367 , "waste_disposal_method")(req, res, next);
  },
  controllerWrapper(createUpdateWasteDisposalMethod)
);

/**
 * @swagger
 * /api/wasteDisposalMethod/get-waste-disposal-method:
 *   get:
 *     summary: Get all records of WasteDisposalMethod
 *     tags: [WasteDisposalMethod]
 */
wasteDisposalMethodRoutes.get(
  "/get-waste-disposal-method",
  verifyToken,
  sideBarPermissionCheck("view", 367, "waste_disposal_method"),
  controllerWrapper(viewWasteDisposalMethod)
);

/**
 * @swagger
 * /api/wasteDisposalMethod/get-waste-disposal-method/{id}:
 *   get:
 *     summary: Get a specific record of WasteDisposalMethod
 *     tags: [WasteDisposalMethod]
 */
wasteDisposalMethodRoutes.get(
  "/get-waste-disposal-method/:id",
  verifyToken,
  sideBarPermissionCheck("view", 367, "waste_disposal_method"),
  controllerWrapper(viewWasteDisposalMethod)
);

/**
 * @swagger
 * /api/wasteDisposalMethod/delete-waste-disposal-method/{id}:
 *   delete:
 *     summary: Delete a specific record of WasteDisposalMethod
 *     tags: [WasteDisposalMethod]
 */
wasteDisposalMethodRoutes.delete(
  "/delete-waste-disposal-method/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 367, "waste_disposal_method"),
  controllerWrapper(deleteWasteDisposalMethod)
);

export default wasteDisposalMethodRoutes;