import ContractorIncident from "./ContractorIncidentSchema.js";
import Repository from "./RepositorySchema.js";
import sequelize from "./sequelize.js";
import { DataTypes } from "sequelize";

const ContractorIncidentDocs = sequelize.define(
  "ContractorIncidentDocs",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    doc_no: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    contractor_incident_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorIncident,
        key: "id",
      },
      onDelete: "SET NULL",
      onUpdate: "CASCADE",
    },
    title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    file: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    timestamps: false,

    tableName: "contractor_incident_docs",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);
// console.log(await ContractorIncidentDocs.sync({ alter: true }));
export default ContractorIncidentDocs;
