import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import ContractorRegistration from "./ContractorRegistrationSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";
import ProjectRegistration from "./ProjectRegistrationSchema.js";
import ContractorForms from "./ContractorFormSchema.js";

const ContractorQuestionnaire = sequelize.define(
  "ContractorQuestionnaire",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorRegistration,
        key: "id",
      },
    },
    total: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    responses: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    status: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },

    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    timestamps: false,

    tableName: "contractor_questionnaire",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ContractorQuestionnaire.belongsTo(ContractorRegistration, {
  foreignKey: "contractor",
  as: "ContractorRegistration",
});
ContractorQuestionnaire.belongsTo(ProjectRegistration, {
  foreignKey: "project",
  as: "ProjectRegistration",
});
ContractorQuestionnaire.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
ContractorQuestionnaire.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});
ContractorQuestionnaire.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});
ContractorQuestionnaire.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});

// console.log(await ContractorQuestionnaire.sync({ alter: true }));

export default ContractorQuestionnaire;
