import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import ContractorSafeWorking from "./ContractorSafeWorkingSchema.js";

const ContractorSafeWorkingDocs = sequelize.define(
  "ContractorSafeWorkingDocs",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    doc_no: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    contractor_safe_working_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorSafeWorking,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    file: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "contractor_safe_working_docs",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ContractorSafeWorkingDocs.belongsTo(ContractorSafeWorking, {
  foreignKey: "contractor_safe_working_id",
  as: "Contractor",
});

export default ContractorSafeWorkingDocs;
