import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import User from "./UserSchema.js";
import ContractorRegistration from "./ContractorRegistrationSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import ProjectRegistration from "./ProjectRegistrationSchema.js";
import Repository from "./RepositorySchema.js";

const ContractorSiteAccess = sequelize.define(
  "ContractorSiteAccess",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
    },
    project: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ProjectRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    form: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    status: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "Pending",
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    signing_method: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    document: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    timestamps: false,

    tableName: "contractor_site_access",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ContractorSiteAccess.belongsTo(ProjectRegistration, {
  foreignKey: "project",
  as: "Project",
});

ContractorSiteAccess.belongsTo(ContractorRegistration, {
  foreignKey: "contractor",
  as: "Contractor",
});
ContractorSiteAccess.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
ContractorSiteAccess.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});
ContractorSiteAccess.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});
ContractorSiteAccess.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});
// console.log(await ContractorSiteAccess.sync({ alter: true }));

export default ContractorSiteAccess;
