import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import { EndFields } from "../constants/constants.js";
import CrisisLocation from "./CrisisLocationSchema.js";
import CrisisType from "./CrisisTypeSchema.js";
import CommandCenterLocation from "./CommandCenterLocationSchema.js";
import User from "./UserSchema.js";
import Currency from "./CurrencySchema.js";
import BcpManagement from "./BcpManagementSchema.js";
import AffectedArea from "./AffectedAreaSchema.js";
import CriticalSystemAffected from "./CriticalSystemAffectedSchema.js";
import Location from "./LocationSchema.js";

const CrisisManagement = sequelize.define(
  "crisis_management",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    crisis_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    crisis_occurrence_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    crisis_time: {
      type: DataTypes.TIME,
      allowNull: true,
    },
    crisis_location: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Location,
        key: "id",
      },
    },
    crisis_type: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: CrisisType,
        key: "id",
      },
    },
    crisis_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    crisis_declared_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },

    declaration_effective_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },

    declaration_time: {
      type: DataTypes.TIME,
      allowNull: true,
    },
    declaration_reason: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    bcp_activation: {
      type: DataTypes.ENUM("Yes", "No"),
      allowNull: true,
    },
    bcp_management_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: BcpManagement,
        key: "id",
      },
    },

    initial_action_taken: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    mobilization_time: {
      type: DataTypes.TIME,
      allowNull: true,
    },

    command_center_location: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Location,
        key: "id",
      },
    },
    crisis_response_actions: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    immediate_decisions_made: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    external_parties_contacted: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    crisis_communications: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    affected_areas: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: AffectedArea,
        key: "id",
      },
    },
    critical_system_affected: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: CriticalSystemAffected,
        key: "id",
      },
    },
    impact_of_operations: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    currency: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Currency,
        key: "id",
      },
    },
    value: {
      type: DataTypes.DECIMAL,
      allowNull: true,
    },
    recovery_time_objective: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    crisis_need_to_be_escalated: {
      type: DataTypes.ENUM("Yes", "No"),
      allowNull: true,
    },
    escalation_reason: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    escalation_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    escalation_time: {
      type: DataTypes.TIME,
      allowNull: true,
    },
    escalation_to: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    escalation_user_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    escalation_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    crisis_management_team_leader: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    crisis_management_team_leader_responsibilities: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },

    deputy_crisis_management_team_leader: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    deputy_crisis_management_team_leader_responsibilities: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    emergency_response_coordinator: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },

    emergency_response_coordinator_responsibilities: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    technical_recovery_lead: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },

    technical_recovery_lead_responsibilities: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },

    communication_officer: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },

    communication_officer_responsibilities: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    legal_and_compliance_officer: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    legal_and_compliance_officer_responsibilities: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    hr_representative: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    hr_representative_responsibilities: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    operation_recovery_lead: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    operation_recovery_lead_responsibilities: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    finance_and_administration_lead: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    finance_and_administration_lead_responsibilities: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    facilities_and_physical_infrastructure: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    facilities_and_physical_infrastructure_responsibilities: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    supply_chain_and_procurement_lead: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    supply_chain_and_procurement_lead_responsibilities: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    external_liaison_officer: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    external_liaison_officer_responsibilities: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    security_lead: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    security_lead_responsibilities: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    risk_management_officer: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    risk_management_officer_responsibilities: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    crisis_documentation_officer: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    crisis_documentation_official_responsibilities: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    resource_allocation: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    deactivation_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },

    deactivation_time: {
      type: DataTypes.TIME,
      allowNull: true,
    },
    deactivation_reason: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    deactivation_user_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    restoration_of_services: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    step_taken_for_resolution: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    action_plan: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    areas_of_improvement: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    lessons_learned: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    post_crisis_review_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    ...EndFields,
  },
  {
    tableName: "crisis_management",
    sequelize,
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

export default CrisisManagement;

// console.log(await CrisisManagement.sync({ alter: true }));
