import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import Equipment from "./EquipmentSchema.js";
import Location from "./LocationSchema.js";
import User from "./UserSchema.js";
const FireEquipmentRegister = sequelize.define(
  "FireEquipmentRegister",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    currency: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    recording_type: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    maintenance_cost: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    equipment_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    inspection_checkbox: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    equipment_category: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    action_taken: {
      type: DataTypes.INTEGER,
      allowNull: true,
      //reference:{Custom Action Creation Table}
    },
    task_data: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    immediate_cause: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    root_cause: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    schedule: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    inspection_checklist: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    unique_equipment_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    value: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    equipment_type: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    unique_equipment_id: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    location: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Location,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    installation_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    inspection_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    last_maintenance_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    next_maintenance_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    for_reported_by_department: {
      type: DataTypes.STRING(255),
    },
    reported_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    supplier_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    inspection_outcome: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    maintenance_frequency: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    maintenance_provider: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    investigation_outcome: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    modal_number: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    capacity: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    status: {
      type: DataTypes.ENUM(
        "Operational",
        "Needs Repair",
        "Maintenance Overdue",
        "Decommissioned",
        "Not Operational",
        "Under Maintenance"
      ),
      allowNull: true,
      defaultValue: "Operational",
    },
    last_updated_date: {
      type: DataTypes.DATE,
    },
    for_reported_by_role: {
      type: DataTypes.STRING(255),
    },
    notify_to: {
      type: DataTypes.INTEGER,
    },
    notify_to_department: {
      type: DataTypes.STRING(255),
    },
    notify_to_role: {
      type: DataTypes.STRING(255),
    },
    remarks_comments: {
      type: DataTypes.TEXT("long"),
    },
    remarks_comments: {
      type: DataTypes.TEXT("long"),
    },
    // scheduled_status: {
    //   type: DataTypes.STRING,
    //   allowNull: false,
    //   defaultValue: "Pending",
    // },
    responsible_department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    unique_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    tableName: "fire_equipment_register",
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// Associations
FireEquipmentRegister.belongsTo(Department, {
  as: "DepartmentDetails",
  foreignKey: "department",
});

// Associations
FireEquipmentRegister.belongsTo(Department, {
  as: "responsibleDepartmentDetails",
  foreignKey: "responsible_department",
});

FireEquipmentRegister.belongsTo(Organization, {
  as: "OrganizationDetails",
  foreignKey: "organization",
});

// FireEquipmentRegister.belongsTo(Equipment, {
//   as: "EquipmentDetails",
//   foreignKey: "equipment_type",
// });

// console.log(await FireEquipmentRegister.sync({ alter: true }));

export default FireEquipmentRegister;
