import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import User from "./UserSchema.js";

const InsuranceClaim = sequelize.define(
  "insurance_claim",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    investigation_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    reference_no: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    incident_report_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    internal_insurance_claim_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    incident_category: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    date_of_incident: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    time_of_incident_occurrence: {
      type: DataTypes.TIME,
      allowNull: true,
    },
    initial_incident_severity: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    location: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    insurance_policy_impact: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    estimated_damage_cost: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    currency: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    claim_number: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    actual_damage_cost: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    insurance_claim_approval_status: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "Pending",
    },
    insurance_claim_payout_status: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "Pending",
    },
    comments: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    insurance_approved_amount: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    insurance_approval_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    reason: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    appeal: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    responsible_person: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    actual_payout_amount: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    organization: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    department: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    deleted: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    timestamps: false,

    tableName: "insurance_claim",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

InsuranceClaim.belongsTo(User, { foreignKey: "created_by", as: "CreatedBy" });
InsuranceClaim.belongsTo(User, { foreignKey: "updated_by", as: "UpdatedBy" });

// console.log(await InsuranceClaim.sync({ alter: true }));
export default InsuranceClaim;
