import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import Incident from "./IncidentSchema.js";
import CategoryType from "./CategoryTypeSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";

const NonComplianceTechnicalForm = sequelize.define(
  "NonComplianceTechnicalForm",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    incident_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Incident,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    incident_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    incident_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    incident_time: {
      type: DataTypes.TIME,
      allowNull: true,
    },
    initial_incident_severity: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    incident_category: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    incident_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    incident_location: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    quality_incident_details: {
      type: DataTypes.JSON,
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },

    save_type: {
      type: DataTypes.STRING(255),
      allowNull: true,
      // example: "draft"(only),
    },
    for_contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    references_number: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    // notify:{
    //     type: DataTypes.TEXT("long"),
    //     allowNull: true,
    // },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    timestamps: false,

    tableName: "non_compliance_technical_form",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// NonComplianceTechnicalForm.belongsTo(Incident, {
//   foreignKey: "incident_id",
//   as: "Incident",
// });
NonComplianceTechnicalForm.belongsTo(CategoryType, {
  foreignKey: "category_id",
  as: "Category",
});
NonComplianceTechnicalForm.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
NonComplianceTechnicalForm.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});
NonComplianceTechnicalForm.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});
NonComplianceTechnicalForm.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});
// console.log(await NonComplianceTechnicalForm.sync({ alter: true }));
export default NonComplianceTechnicalForm;
