import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import OhsFileAssessment from "./OhsFileAssessmentSchema.js";
import Repository from "./RepositorySchema.js";

const OhsFileDocs = sequelize.define(
  "OhsFileDocs",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    doc_no: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
    },
    ohs_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: OhsFileAssessment,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    file: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "ohs_file_docs",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

OhsFileDocs.belongsTo(OhsFileAssessment, {
  foreignKey: "ohs_id",
  as: "OhsFileAssessment",
});
// console.log(await OhsFileDocs.sync({ alter: true }));

export default OhsFileDocs;
