import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js"; // User model for created_by, updated_by references

const SOP = sequelize.define(
  "sop",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    // amendment: {
    //   type: DataTypes.BOOLEAN,
    //   allowNull: true,
    //   defaultValue: false,
    // },
    new_sop: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: true,
    },
    is_archived: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    affected_sop: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    sop_id: {
      type: DataTypes.STRING(100),
    },
    sop_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    sop_number: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    sop_department: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    for_approval_employee: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    // for_approval_role: {
    //   type: DataTypes.STRING(100),
    //   allowNull: true,
    // },
    revision_version_number: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    version_number: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    sop_classification: {
      type: DataTypes.ENUM("Unclassified", "Confidential", "Restricted", "Private"),
      allowNull: true,
    },
    sop_process: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    sop_category: {
      type: DataTypes.INTEGER, //sop_category in settings table
      allowNull: true,
    },
    version_number: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    sop_effective_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    last_review_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    next_review_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    revision_effective_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    sop_status: {
      type: DataTypes.ENUM("Draft", "Under Review", "Complete"),
      allowNull: true,
      defaultValue: "Draft",
    },
    sop_detail_status: {
      type: DataTypes.ENUM("Valid", "Overdue", "Under Review "),
      allowNull: true,
      defaultValue: "Under Review ",
    },
    current_status: {
      type: DataTypes.ENUM(
        "pending",
        "reviewing",
        "approval",
        "approved",
        "rejected"
      ),
      allowNull: true,
      defaultValue: "pending",
    },
    sop_purpose: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    details_of_addition: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    sop_scope: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    sop_statement: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    sop_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    sop_terms: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    sop_roles_responsibilities: {
      type: DataTypes.JSON,
      allowNull: true,
    },
    sop_abbreviations: {
      type: DataTypes.JSON,
      allowNull: true,
    },
    sop_revision_history: {
      type: DataTypes.JSON,
      allowNull: true,
    },
    file_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    ddrm_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    file_classification: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    type_of_sop: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    notify_to: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    for_review: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    sop_author: {
      type: DataTypes.INTEGER,
      references: {
        model: User,
        key: "id",
      },
      allowNull: true,
    },
    sop_reviewer: {
      type: DataTypes.TEXT("long"), // In case multiple reviewers
      allowNull: true,
    },
    stakeholder: {
      type: DataTypes.TEXT("long"), // In case multiple reviewers
      allowNull: true,
    },
    with_access_items: {
      type: DataTypes.TEXT("long"), // In case multiple reviewers
      allowNull: true,
    },
    without_access_items: {
      type: DataTypes.TEXT("long"), // In case multiple reviewers
      allowNull: true,
    },
    without_access_and_without_email: {
      type: DataTypes.TEXT("long"), // In case multiple reviewers
      allowNull: true,
    },
    sop_approver: {
      type: DataTypes.INTEGER,
      allowNull: true,
      // references: {
      //   model: User,
      //   key: "id",
      // },
      // onUpdate: "CASCADE",
      // onDelete: "SET NULL",
    },
    // sop_approver_department_name: {
    //   type: DataTypes.INTEGER,
    //   allowNull: true,
    //   // references: {
    //   //   model: User,
    //   //   key: "id",
    //   // },
    //   // onUpdate: "CASCADE",
    //   // onDelete: "SET NULL",
    // },
    // sop_approver_role_name: {
    //   type: DataTypes.INTEGER,
    //   allowNull: true,
    //   // references: {
    //   //   model: User,
    //   //   key: "id",
    //   // },
    //   // onUpdate: "CASCADE",
    //   // onDelete: "SET NULL",
    // },
    sop_author: {
      type: DataTypes.INTEGER,
      allowNull: true,
      // references: {
      //   model: User,
      //   key: "id",
      // },
    },
    // sop_author_department_name: {
    //   type: DataTypes.INTEGER,
    //   allowNull: true,
    //   // references: {
    //   //   model: User,
    //   //   key: "id",
    //   // },
    // },
    // sop_author_role_name: {
    //   type: DataTypes.INTEGER,
    //   allowNull: true,
    //   // references: {
    //   //   model: User,
    //   //   key: "id",
    //   // },
    // },
    sop_owner: {
      type: DataTypes.INTEGER,
      allowNull: true,
      // references: {
      //   model: User,
      //   key: "id",
      // },
    },
    // sop_owner_department_name: {
    //   type: DataTypes.INTEGER,
    //   allowNull: true,
    //   // references: {
    //   //   model: User,
    //   //   key: "id",
    //   // },
    // },
    // sop_owner_role_name: {
    //   type: DataTypes.INTEGER,
    //   allowNull: true,
    //   // references: {
    //   //   model: User,
    //   //   key: "id",
    //   // },
    // },
    unique_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
  },
  {
    tableName: "sops",
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// Associations
SOP.belongsTo(Organization, {
  as: "organizationDetails",
  foreignKey: "organization",
});
SOP.belongsTo(Department, {
  as: "departmentDetails",
  foreignKey: "department",
});
SOP.belongsTo(User, {
  as: "authorDetails",
  foreignKey: "sop_author",
});
SOP.belongsTo(User, {
  as: "approverDetails",
  foreignKey: "sop_approver",
});

// console.log(await SOP.sync({ alter: true }));

export default SOP;
