import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary

const sidebarSchema = {
  id: {
    type: DataTypes.INTEGER,
    autoIncrement: true,
    primaryKey: true,
  },
  title: {
    type: DataTypes.STRING(500),
    allowNull: true,
  },
  icon: {
    type: DataTypes.STRING(500),
    allowNull: true,
  },
  path: {
    type: DataTypes.STRING(500),
    allowNull: true,
  },
  type: {
    type: DataTypes.ENUM("Module", "Tab", "SubTab"),
    allowNull: true,
    defaultValue: "Module",
  },
  table_name: {
    type: DataTypes.STRING(500),
    allowNull: true,
  },
  comment: {
    type: DataTypes.STRING(500),
    allowNull: true,
  },
  dependent_module: {
    type: DataTypes.INTEGER,
    allowNull: true,
  },
  deleted: {
    type: DataTypes.INTEGER,
    allowNull: true,
    defaultValue: 0,
  },
  parent_id: {
    type: DataTypes.INTEGER,
    allowNull: true,
    defaultValue: 0,
  },
  sequence: {
    type: DataTypes.INTEGER,
    allowNull: true,
  },
  dependency: {
    type: DataTypes.JSON,
    allowNull: true,
  },
};

const Sidebar = sequelize.define("Sidebar", sidebarSchema, {
  tableName: "sidebar",
  timestamps: false,

  charset: "utf8mb4",
  collate: "utf8mb4_general_ci",
});

// console.log(await Sidebar.sync({ alter: true }));
export { sidebarSchema };
export default Sidebar;
