import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import StakeHolderIdentification from "./StakeholderIdentificationSchema.js";
import StakeholderEngagementPlan from "./StakeholderEngagementPlanSchema.js";

const StakeholderActivityScheduling = sequelize.define(
  "StakeholderActivityScheduling",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    stakeholder: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: StakeholderEngagementPlan,
        key: "id",
      },
    },
    engagement_plan: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    // engagement_type: {
    //   type: DataTypes.STRING(255),
    //   allowNull: true,
    // },
    engagement_details: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    engagement_method: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    engagement_plan_objective: {
      type: DataTypes.STRING(255),
    },
    frequency_of_engagement: {
      type: DataTypes.STRING(255),
    },
    responsible_person: {
      type: DataTypes.STRING(255),
    },
    identification_id: {
      type: DataTypes.INTEGER,
      references: {
        model: StakeHolderIdentification,
        key: StakeHolderIdentification.primaryKeyAttribute,
      },
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    response_received: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    status: {
      type: DataTypes.ENUM("To do", "In Progress", "Completed", "Overdue"),
      allowNull: true,
      defaultValue: "To do",
    },

    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    tableName: "stakeholder_activity_scheduling",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

StakeholderActivityScheduling.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});

StakeholderActivityScheduling.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});

StakeholderActivityScheduling.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});

StakeholderActivityScheduling.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});

// console.log(await StakeholderActivityScheduling.sync({ alter: true }));

export default StakeholderActivityScheduling;
