import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import StrategicRisk from "./StrategicRiskSchema.js";
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";

const StrategicRiskIdentification = sequelize.define(
  "StrategicRiskIdentification",
  {
    id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      autoIncrement: true,
      primaryKey: true,
    },
    risk_register_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: StrategicRisk,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    risk_owner: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    risk_name: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    risk_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    impact_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    causes_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    inherent_likelihood: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    inherent_consequence: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    inherent_risk_rating: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    inherent_risk_ranking: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    control_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    // control_name: {
    //   type: DataTypes.STRING(500),
    //   allowNull: true,
    // },
    // control_description: {
    //   type: DataTypes.TEXT("long"),  //field removed
    //   allowNull: true,
    // },
    // control_design_intent: {
    //   type: DataTypes.STRING(500),
    //   allowNull: true,
    // },
    // control_effectiveness: {
    //   type: DataTypes.STRING(500),
    //   allowNull: true,
    // },
    // control_owner: {
    //   type: DataTypes.INTEGER,
    //   allowNull: true,
    //   references: {
    //     model: User,      //field removed
    //     key: "id",
    //   },
    //   //onUpdate: "CASCADE",
    //   //onDelete: "SET NULL",
    // },
    residual_risk_rating: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    residual_risk_ranking: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    control_identification: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    opportunity_identification: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    opportunity_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    priority_confirmation: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    tableName: "strategic_risk_identification",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

StrategicRiskIdentification.belongsTo(StrategicRisk, {
  foreignKey: "risk_register_id",
  as: "StrategicRisk",
});

StrategicRiskIdentification.belongsTo(User, {
  foreignKey: "risk_owner",
  as: "RiskOwner",
});

// StrategicRiskIdentification.belongsTo(User, {
//   foreignKey: "control_owner",
//   as: "ControlOwner",
// });

StrategicRiskIdentification.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});

StrategicRiskIdentification.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});

StrategicRiskIdentification.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});

StrategicRiskIdentification.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});
// console.log(await StrategicRiskIdentification.sync({ alter: true }));
export default StrategicRiskIdentification;
