import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
 
const Team = sequelize.define(
  "Team",
  {
    id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      autoIncrement: true,
      primaryKey: true,
    },
    name: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    team_leader: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    team_members: {
      type: DataTypes.JSON,
      allowNull: true,
      // charset: "utf8mb4",
      // collate: "utf8mb4_bin",
    },
    organization: {
      type: DataTypes.INTEGER,
      // allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      // allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      // allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      // allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "teams",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

Team.belongsTo(User, {
  foreignKey: "team_leader",
  as: "TeamLeader",
});

Team.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});

Team.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});

Team.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});

Team.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});

// console.log(await Team.sync({ alter: true }));

export default Team;
