import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";
import FileClassification from "./FileClassificationSchema.js";
import BestPractice from "./BestPracticeSchema.js";
import Repository from "./RepositorySchema.js";

const KnowledgeManagementRecording = sequelize.define(
  "KnowledgeManagementRecording",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    knowledge_management_type: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    lesson_best_practice_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    title: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    category: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    author: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    date_of_submission: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    // supporting_document: {
    //   type: DataTypes.TEXT("long"),
    //   allowNull: true,
    // },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    recommendations: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    key_insights: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    stakeholder: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    keywords: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    implementation_steps: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    comments: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    source: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    file_name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    file_classification: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: FileClassification,
        key: "id",
      },
    },

    reviewer: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    approver: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    current_status: {
      type: DataTypes.ENUM("reviewing", "approval", "approved", "rejected"),
      allowNull: true,
      defaultValue: "reviewing",
    },
    status: {
      type: DataTypes.ENUM("complete"),
      allowNull: true,
      defaultValue: "complete",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    timestamps: false,

    tableName: "knowledge_management_recording",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

KnowledgeManagementRecording.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
KnowledgeManagementRecording.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});
KnowledgeManagementRecording.belongsTo(User, {
  foreignKey: "author",
  as: "Author",
});
KnowledgeManagementRecording.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});
KnowledgeManagementRecording.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});
// console.log(await KnowledgeManagementRecording.sync({ alter: true }));

export default KnowledgeManagementRecording;
