import { Sequelize } from "sequelize";
import { config } from "dotenv";
import chalk from "chalk";
import defaultImport from "../deploy.js";
import readJsonFile from "../helper/readFileFunction.js";
import path from "path";

config();
const { DATABASE_HOST, DATABASE_USER, DATABASE_PASSWORD, DATABASE_NAME } =
  process.env;
// Create a new Sequelize instance
const sequelize = new Sequelize(
  DATABASE_NAME,
  DATABASE_USER,
  DATABASE_PASSWORD,
  {
    host: DATABASE_HOST,
    dialect: "mysql",
    logging: false,
    // logging: (msg) => console.log(chalk.bgYellowBright(msg)),
  }
);
const clientData = {
  organization: "Harmony & HELP Organization",
  name: "Marrium",
  surname: "Sampson",
  email: "8IwJt@example.com",
  password: "password",
};
// console.log(JSON.parse(process.argv[2]));
const sync = async () => {
  if (process.env.NODE_ENV === "development") {
    console.log("Sync started");
    await sequelize.sync({ alter: true });
    console.log("table created successfully");
    return;
  }
};

// sequelize.sync({ alter: true });

export default sequelize;
